/*//////////////////////////////////////////////////////////////////
//  This file is part of IJ_IDS_Cam plugin for ImageJ.
//
//  IJ_IDS_Cam is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  IJ_IDS_Cam is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with IJ_IDS_Cam.  If not, see <http://www.gnu.org/licenses/>.
//
// Copyright 2015-2016 Côme PASQUALIN, François GANNIER
/////////////////////////////////////////////////////////////////*/

import java.io.*;
import java.util.*;
import java.util.concurrent.TimeUnit;

import ij.Prefs;        // Prefs.get

public class listenCOM extends Thread {
	boolean active = false;
	boolean DSR = false;
	boolean CTS = false;
	int comPort = 1;

	GetSync sync;
	public void sendRTS(boolean b) {
		sync.setRTS(b);
	}
	public void switchRTS() {
		sync.switchRTS();
	}
	public void sendDTR(boolean b) {
		sync.setDTR(b);
	}
	public void switchDTR() {
		sync.switchDTR();
	}
	public boolean isStarted(int TO) {	// TO (ms)
		int StartTime = 0;
		int wait=10;
		while(!active)
		{
			try {
				Thread.sleep(wait);
			StartTime+=wait;
			} catch (InterruptedException ex) {}
			if (StartTime > TO)
				return false;
		}
		return true;
	}
	public void resetDSR() {
		DSR = false;
	}
	public void resetCTS(){
		CTS = false;
	}
	public boolean isCTS() {
		if (CTS) {
			CTS = false;
			return true;
		}
		return false;
	}
	public boolean isDSR() {
		if (DSR) {
			DSR = false;
			return true;
		}
		return false;
	}
	public void setPort(int port) {
		comPort = port;
	}
	public void run() {
		sync = new GetSync();
		active = (sync.init(comPort))>0?true:false;
		if (active) {
			Prefs.set("Sync.newCTS",false);
			Prefs.set("Sync.newDSR",false);

			double nDSR = 0, nCTS = 0; 
			while(true) {
				// try {
					// Thread.sleep(1);
					nDSR++; nCTS++;
					if (sync.IsDSR()==1)
						if (System.nanoTime()-nDSR > 2000000)
						{
							Prefs.set("Sync.newDSR",true);
							DSR = true;
							nDSR = System.nanoTime();
						}

					if (sync.IsCTS()==1)
						if (System.nanoTime()-nCTS > 2000000)
						{
							Prefs.set("Sync.newCTS",true);
							CTS = true;
							nCTS = System.nanoTime();
						}
					if (interrupted()) break;
				// }
				// catch (InterruptedException ex) { return ;}
			}
			sync.done();
		}
	}
}