/*//////////////////////////////////////////////////////////////////
//  This file is part of IJ_IDS_Cam plugin for ImageJ.
//
//  IJ_IDS_Cam is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  IJ_IDS_Cam is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with IJ_IDS_Cam.  If not, see <http://www.gnu.org/licenses/>.
//
// Copyright 2015-2016 Côme PASQUALIN, François GANNIER
/////////////////////////////////////////////////////////////////*/

import ij.*;

import java.io.*;
import java.util.*;

import gnu.io.*;
import gnu.io.CommPort;
import gnu.io.PortInUseException;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;


public class GetSync {
	public static SerialPort comPort;
	public static String PortName;
	static boolean dsr = false;
	static boolean cts = false;

	public static boolean console = false; // true;

	private static String OS = System.getProperty("os.name").toLowerCase();
	public static boolean isWindows() {
		return (OS.indexOf("win") >= 0);
	}

	public static void main(String[] arg) {
	}

	public static void ListSerialPorts() {
		java.util.Enumeration<gnu.io.CommPortIdentifier> portEnum = CommPortIdentifier.getPortIdentifiers();
		while ( portEnum.hasMoreElements() )
		{
			CommPortIdentifier portIdentifier = portEnum.nextElement();
			switch (portIdentifier.getPortType()) {
				case CommPortIdentifier.PORT_SERIAL:
					try {
						CommPort thePort = portIdentifier.open("CommUtil", 50);
						thePort.close();
						Display("Port "  + portIdentifier.getName() + " free to use.");
					} catch (PortInUseException e) {
						Display("Port "  + portIdentifier.getName() + " is in use.");
					} catch (Exception e) {
						Display("Failed to open port " +  portIdentifier.getName());
						e.printStackTrace();
					}
			}
		}
	}

	public static long init(int nPort) {
		if (isWindows())
			PortName = "COM"+nPort;
		else  PortName = "/dev/ttyS"+(nPort-1);
//copy librxtxSerial.so dans /usr/lib/jvm/java/jre/lib/...
//setserial -g /dev/ttyS*		// voir les ports existant
//ls -l /dev/ttyS*				// voir les droits
//->membre du group dialout lock et uucp
		String st="";
		try {
			st = "Opening port " + PortName + " : ";
			CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(PortName);
			if (portIdentifier.isCurrentlyOwned()) {
				Display(st + "currently in use by " + portIdentifier.getCurrentOwner());
				return 0;
			} else {
				comPort = (SerialPort) portIdentifier.open("ImageJ", 100);
				Display(st+"opened");
			}
		}
		catch (Exception e) {
			Display(st+"error");
			return 0;
		}

		int baudRate = 115200;
		try {
		  comPort.setSerialPortParams(
			baudRate,
			comPort.DATABITS_8,
			comPort.STOPBITS_1,
			comPort.PARITY_NONE);
			Display("Setting "+PortName);
		} catch (UnsupportedCommOperationException ex) {
			st = "Error opening port " + PortName + "(" + ex.getMessage() +")";
			Display(st);
		}
		return 1;
	}

	public static long init(String nPort) {
		return init((int) Double.parseDouble(nPort));
	}

	public static void done() { // Done
		String st="";
		try {
			if (comPort != null) {
				comPort.close();
				comPort = null;
				// data = "";
				st="Serial port closed";
			}
		} catch (Exception e) {
			st="Exception closing serial port";
		}
		Display(st);
	}

/*	public static long isSync() {
		if (comPort.isDSR())
			return 1;
		return 0;
	}
/* */
	public static long IsDSR() {
		if (comPort.isDSR())
			return 1;
		return 0;
	}
	public static long IsDTR() {
		if (comPort.isDTR())
			return 1;
		return 0;
	}
	public static long IsRTS() {
		if (comPort.isRTS())
			return 1;
		return 0;
	}
	public static long IsCTS() {
		if (comPort.isCTS())
			return 1;
		return 0;
	}

	public static void setRTS(boolean b) {
		comPort.setRTS(b);
		// Display("sending RTS");
	}

	public static void switchRTS() {
		comPort.setRTS(!comPort.isRTS());
	}

	public static void setDTR(boolean b) {
		comPort.setDTR(b);
		// Display("sending DTR");
	}

	public static void switchDTR() {
		comPort.setDTR(!comPort.isDTR());
	}

	public static void Display(String st) {
		if (console) System.err.println(st);	else IJ.log(st);
	}
}