/*
 * Decompiled with CFR 0.152.
 */
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import ij.IJ;
import java.io.IOException;
import java.util.Enumeration;

public class GetSync {
    public static SerialPort comPort;
    public static String PortName;
    static boolean dsr;
    static boolean cts;
    public static boolean console;
    private static String OS;

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static void main(String[] arg) {
    }

    public static void ListSerialPorts() {
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            switch (portIdentifier.getPortType()) {
                case 1: {
                    try {
                        CommPort thePort = portIdentifier.open("CommUtil", 50);
                        thePort.close();
                        GetSync.Display("Port " + portIdentifier.getName() + " free to use.");
                        break;
                    }
                    catch (PortInUseException e) {
                        GetSync.Display("Port " + portIdentifier.getName() + " is in use.");
                        break;
                    }
                    catch (Exception e) {
                        GetSync.Display("Failed to open port " + portIdentifier.getName());
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static long init(int nPort) {
        PortName = GetSync.isWindows() ? "COM" + nPort : (nPort > 50 ? "/dev/ttyUSB" + (nPort - 51) : "/dev/ttyS" + (nPort - 1));
        String st = "";
        try {
            st = "Opening port " + PortName + " : ";
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)PortName);
            if (portIdentifier.isCurrentlyOwned()) {
                GetSync.Display(st + "currently in use by " + portIdentifier.getCurrentOwner());
                return 0L;
            }
            comPort = (SerialPort)portIdentifier.open("ImageJ", 100);
            GetSync.Display(st + "opened");
        }
        catch (Exception e) {
            GetSync.Display(st + "error");
            return 0L;
        }
        int baudRate = 115200;
        try {
            comPort.setSerialPortParams(baudRate, 8, 1, 0);
            GetSync.Display("Setting " + PortName);
        }
        catch (UnsupportedCommOperationException ex) {
            st = "Error opening port " + PortName + "(" + ex.getMessage() + ")";
            GetSync.Display(st);
        }
        return 1L;
    }

    public static long init(String nPort) {
        return GetSync.init((int)Double.parseDouble(nPort));
    }

    public static long send(String val) {
        int b = Integer.parseInt(val);
        try {
            comPort.getOutputStream().write((byte)b);
            comPort.getOutputStream().close();
        }
        catch (IOException e) {
            System.out.println("err3");
        }
        return 1L;
    }

    public static long send(byte val) {
        try {
            comPort.getOutputStream().write(val);
            comPort.getOutputStream().close();
        }
        catch (IOException e) {
            System.out.println("err3");
        }
        return 1L;
    }

    public static long isOpen() {
        if (comPort != null) {
            return 1L;
        }
        return 0L;
    }

    public static void done() {
        String st = "";
        try {
            if (comPort != null) {
                comPort.close();
                comPort = null;
                st = "Serial port closed";
            }
        }
        catch (Exception e) {
            st = "Exception closing serial port";
        }
        GetSync.Display(st);
    }

    public static long IsDSR() {
        if (comPort.isDSR()) {
            return 1L;
        }
        return 0L;
    }

    public static long IsDTR() {
        if (comPort.isDTR()) {
            return 1L;
        }
        return 0L;
    }

    public static long IsRTS() {
        if (comPort.isRTS()) {
            return 1L;
        }
        return 0L;
    }

    public static long IsCTS() {
        if (comPort.isCTS()) {
            return 1L;
        }
        return 0L;
    }

    public static void setRTS(boolean b) {
        comPort.setRTS(b);
    }

    public static void switchRTS() {
        comPort.setRTS(!comPort.isRTS());
    }

    public static void setDTR(boolean b) {
        comPort.setDTR(b);
    }

    public static void switchDTR() {
        comPort.setDTR(!comPort.isDTR());
    }

    public static void Display(String st) {
        if (console) {
            System.err.println(st);
        } else {
            IJ.log((String)st);
        }
    }

    static {
        dsr = false;
        cts = false;
        console = false;
        OS = System.getProperty("os.name").toLowerCase();
    }
}

