/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.File;

public class Hanning
implements PlugIn {
    String sVer = "Hanning Win for ImageJ ver. 1.2";
    String sCop = "Copyright \u00a9 2014-2016 F.GANNIER - C.PASQUALIN";
    String[] Args;

    public void run(String string) {
        short s;
        String string2 = Macro.getOptions();
        if (string2 == null) {
            string = this.showDialog();
        } else {
            string = Macro.getValue((String)string2, (String)"fftsize", null);
            if (string == null) {
                return;
            }
        }
        try {
            s = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (s > 7) {
            String string3 = "hanning" + s + ".tif";
            String string4 = IJ.getDirectory((String)"temp");
            File file = new File(string4 + string3);
            ImagePlus imagePlus = IJ.createImage((String)string3, (String)"32-bit Black", (int)s, (int)s, (int)1);
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            if (imageProcessor != null) {
                float[] fArray = (float[])imageProcessor.getPixels();
                for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                    IJ.showProgress((int)s2, (int)s);
                    for (short s3 = 0; s3 < s; s3 = (short)(s3 + 1)) {
                        double d = 2.0 * (double)s3 / (double)s - 1.0;
                        double d2 = 2.0 * (double)s2 / (double)s - 1.0;
                        double d3 = 1.0 * d * d + d2 * d2;
                        d3 = Math.sqrt(d3);
                        double d4 = 0.5 * (Math.cos(Math.PI * d3) + 1.0);
                        fArray[s3 + s2 * s] = (float)d4;
                    }
                }
                imagePlus.show();
                IJ.saveAs((ImagePlus)imagePlus, (String)"Tiff", (String)(string4 + string3));
            }
        }
    }

    String showDialog() {
        String[] stringArray = new String[]{"32", "64", "128", "256", "512", "1024", "2048", "4096", "8192"};
        GenericDialog genericDialog = new GenericDialog(this.sVer);
        genericDialog.addChoice("Size : ", stringArray, "1024");
        genericDialog.addMessage(this.sCop);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return "0";
        }
        return genericDialog.getNextChoice();
    }
}

