/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.MessageDialog;
import ij.gui.PolygonRoi;
import ij.measure.Calibration;
import ij.plugin.ImageCalculator;
import ij.plugin.PlugIn;
import ij.plugin.filter.RankFilters;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;

public class CTI_org
implements PlugIn {
    String sVer = "CTI Module ver. 1.0";
    String sCop = "Copyright \u00a9 2014 F.GANNIER - C.PASQUALIN";
    int ssize;
    int amp;
    int level;
    int noise;
    int gnoise;
    int TCP;
    int LCP;
    int Nturn;
    int org_lvl;
    float period;
    float angle;
    float resol;
    float HCS;
    float WCS;
    String path;
    String name;
    boolean b_save;

    public void run(String string) {
        this.org_lvl = 100;
        this.loadDefaultValues();
        if (string.equals("auto")) {
            this.createImage();
            return;
        }
        if (this.showDialog() == 0) {
            return;
        }
        if (this.b_save) {
            this.saveFile();
        }
        if (this.period > 0.0f) {
            if (this.Nturn > 0) {
                String string2 = this.name;
                for (int i = 1; i <= this.Nturn; ++i) {
                    this.name = string2 + "_" + i;
                    this.createImage();
                }
                this.name = string2;
            } else {
                this.createImage();
            }
        } else {
            MessageDialog messageDialog = new MessageDialog(null, "Info", "No image created");
        }
        this.saveValues();
    }

    void createImage() {
        ImagePlus imagePlus = IJ.createImage((String)"Test", (String)"16-bit Black", (int)this.ssize, (int)this.ssize, (int)1);
        if (imagePlus != null) {
            Calibration calibration = new Calibration(imagePlus);
            calibration.setUnit("microns");
            calibration.pixelHeight = this.resol;
            calibration.pixelWidth = this.resol;
            imagePlus.setCalibration(calibration);
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            if (imageProcessor != null) {
                Object object;
                Object[] objectArray;
                int n = this.noise * 5;
                int n2 = (int)((float)(this.ssize / 2) - this.HCS / this.resol / 2.0f);
                int n3 = (int)((float)(this.ssize / 2) - this.WCS / this.resol / 2.0f);
                int n4 = (int)(this.HCS / this.resol + (float)n2);
                int n5 = (int)(this.WCS / this.resol + (float)n3);
                int n6 = 0;
                if (imagePlus.getType() == 1) {
                    objectArray = (short[])imageProcessor.getPixels();
                    double d = 1.0f * (95.0f - (float)this.org_lvl) / 100.0f;
                    object = new Random();
                    for (int i = n2 - this.LCP; i < n4 - this.LCP; ++i) {
                        IJ.showProgress((int)i, (int)this.ssize);
                        double d2 = (1.0 + Math.sin(Math.PI * 2 * (double)i * (double)this.resol * 1000.0 / (double)this.period)) * (double)this.amp * 325.0 + (double)(this.level * 650);
                        d2 = d2 < 0.0 ? 0.0 : d2;
                        d2 = d2 > 65534.0 ? 65534.0 : d2;
                        for (int j = n3 - this.TCP; j < n5 - this.TCP; ++j) {
                            double d3 = ((Random)object).nextFloat();
                            objectArray[j + i * this.ssize] = d3 > d ? (short)d2 : (d3 > d / 20.0 ? (short)(50.0 * d3) : (short)(65534.0 - d2));
                        }
                    }
                }
                IJ.setForegroundColor((int)50, (int)50, (int)50);
                imageProcessor.setColor(new Color(50, 50, 50));
                objectArray = new int[]{n3 - this.TCP + 5, n3 - this.TCP - 5, n3 - this.TCP + 5};
                int[] nArray = new int[]{n2 - this.LCP, n2 - this.LCP + (n4 - n2) / 2, n4 - this.LCP};
                PolygonRoi polygonRoi = new PolygonRoi((int[])objectArray, nArray, 3, 6);
                polygonRoi.fitSpline();
                polygonRoi.setStrokeWidth(2.5);
                polygonRoi.drawPixels(imageProcessor);
                int[] nArray2 = new int[]{n5 - this.TCP - 4, n5 - this.TCP + 6, n5 - this.TCP - 5};
                int[] nArray3 = new int[]{n2 - this.LCP, n2 - this.LCP + (n4 - n2) / 2, n4 - this.LCP};
                polygonRoi = new PolygonRoi(nArray2, nArray3, 3, 6);
                polygonRoi.fitSpline();
                polygonRoi.setStrokeWidth(2.5);
                polygonRoi.drawPixels(imageProcessor);
                int[] nArray4 = new int[]{n3 - this.TCP + 5, n3 - this.TCP + (n5 - n3) / 2, n5 - this.TCP - 4};
                int[] nArray5 = new int[]{n2 - this.LCP, n2 - this.LCP - 4, n2 - this.LCP};
                polygonRoi = new PolygonRoi(nArray4, nArray5, 3, 6);
                polygonRoi.fitSpline();
                polygonRoi.setStrokeWidth(2.5);
                polygonRoi.drawPixels(imageProcessor);
                object = new int[]{n3 - this.TCP + 5, n3 - this.TCP + (n5 - n3) / 2, n5 - this.TCP - 5};
                int[] nArray6 = new int[]{n4 - this.LCP, n4 - this.LCP + 4, n4 - this.LCP};
                polygonRoi = new PolygonRoi((int[])object, nArray6, 3, 6);
                polygonRoi.fitSpline();
                polygonRoi.setStrokeWidth(2.5);
                polygonRoi.drawPixels(imageProcessor);
                imageProcessor.resetRoi();
                if (this.angle != 0.0f) {
                    imageProcessor.setInterpolationMethod(1);
                    imageProcessor.rotate((double)this.angle);
                }
                if (this.noise >= 0) {
                    imageProcessor.noise((double)n);
                } else {
                    ImagePlus imagePlus2 = IJ.openImage((String)(IJ.getDirectory((String)"plugins") + "\\TTorg\\noise5000.tif"));
                    ImageCalculator imageCalculator = new ImageCalculator();
                    imageCalculator.run("XOR", imagePlus, imagePlus2);
                    imagePlus.updateAndDraw();
                    n6 = 4700;
                }
                RankFilters rankFilters = new RankFilters();
                rankFilters.rank(imageProcessor, 2.0, 4);
                rankFilters.rank(imageProcessor, 1.0, 0);
                imageProcessor.subtract((double)(n + n6) * 0.8);
                imageProcessor.multiply(5.0);
                if (this.gnoise >= 0) {
                    imageProcessor.noise((double)this.gnoise);
                }
                imagePlus.show();
                if (!this.path.endsWith("\\")) {
                    this.path = this.path + "\\";
                }
                IJ.saveAs((ImagePlus)imagePlus, (String)"Tiff", (String)(this.path + this.name));
            }
        }
    }

    void loadDefaultValues() {
        this.ssize = (int)Prefs.get((String)"TTorg.size", (double)1024.0);
        this.period = (float)Prefs.get((String)"TTorg.period", (double)1800.0);
        this.amp = (int)Prefs.get((String)"TTorg.amp", (double)100.0);
        this.level = (int)Prefs.get((String)"TTorg.level", (double)-85.0);
        this.angle = (float)Prefs.get((String)"TTorg.angle", (double)0.0);
        this.noise = (int)Prefs.get((String)"TTorg.noise", (double)1000.0);
        this.gnoise = (int)Prefs.get((String)"TTorg.gnoise", (double)10.0);
        this.resol = (float)Prefs.get((String)"TTorg.resol", (double)0.1381);
        this.path = Prefs.get((String)"TTorg.path", (String)IJ.getDirectory((String)"home"));
        this.name = Prefs.get((String)"TTorg.name", (String)"image_test");
        this.TCP = (int)Prefs.get((String)"TTorg.TCP", (double)0.0);
        this.LCP = (int)Prefs.get((String)"TTorg.LCP", (double)0.0);
        this.HCS = (float)Prefs.get((String)"TTorg.HCS", (double)100.0);
        this.WCS = (float)Prefs.get((String)"TTorg.WCS", (double)20.0);
        this.Nturn = (int)Prefs.get((String)"TTorg.Nturn", (double)0.0);
        this.b_save = Prefs.get((String)"TTorg.svParam", (boolean)false);
    }

    void saveValues() {
        Prefs.set((String)"TTorg.size", (int)this.ssize);
        Prefs.set((String)"TTorg.period", (double)this.period);
        Prefs.set((String)"TTorg.amp", (int)this.amp);
        Prefs.set((String)"TTorg.level", (int)this.level);
        Prefs.set((String)"TTorg.angle", (double)this.angle);
        Prefs.set((String)"TTorg.noise", (int)this.noise);
        Prefs.set((String)"TTorg.gnoise", (int)this.gnoise);
        Prefs.set((String)"TTorg.resol", (double)this.resol);
        Prefs.set((String)"TTorg.path", (String)this.path);
        Prefs.set((String)"TTorg.name", (String)this.name);
        Prefs.set((String)"TTorg.LCP", (int)this.LCP);
        Prefs.set((String)"TTorg.TCP", (int)this.TCP);
        Prefs.set((String)"TTorg.HCS", (double)this.HCS);
        Prefs.set((String)"TTorg.WCS", (double)this.WCS);
        Prefs.set((String)"TTorg.Nturn", (int)0);
    }

    void saveFile() {
        try {
            String string = this.path + this.name + ".txt";
            File file = new File(string);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("TTorg.size = " + this.ssize);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("TTorg.period = " + this.period);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("TTorg.amp = " + this.amp);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("TTorg.level = " + this.level);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("TTorg.angle = " + this.angle);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("TTorg.noise = " + this.noise);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("TTorg.gnoise = " + this.gnoise);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("TTorg.resol = " + this.resol);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("TTorg.LCP = " + this.LCP);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("TTorg.TCP = " + this.TCP);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("TTorg.HCS = " + this.HCS);
            bufferedWriter.write("\r\n");
            bufferedWriter.write("TTorg.WCS = " + this.WCS);
            bufferedWriter.write("\r\n");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    int showDialog() {
        GenericDialog genericDialog = new GenericDialog(this.sVer);
        genericDialog.addNumericField("Square Image Size :", (double)this.ssize, 0, 6, "pixels");
        genericDialog.addNumericField("Pixel size :", (double)this.resol, 11, 15, "\u00b5m/pixel");
        genericDialog.addNumericField("Left Cell position :", (double)this.LCP, 0, 6, "pixels");
        genericDialog.addNumericField("Top Cell position :", (double)this.TCP, 0, 6, "pixels");
        genericDialog.addNumericField("Hight Cell size :", (double)this.HCS, 1, 6, "\u00b5m");
        genericDialog.addNumericField("Width Cell size :", (double)this.WCS, 1, 6, "\u00b5m");
        genericDialog.addNumericField("Period :", (double)this.period, 0, 6, "nm");
        genericDialog.addNumericField("Amplitude :", (double)this.amp, 0, 6, "%");
        genericDialog.addNumericField("Basal level :", (double)this.level, 0, 6, "%");
        genericDialog.addNumericField("Organisation level :", (double)this.org_lvl, 0, 6, "%");
        genericDialog.addNumericField("Angle (\u00b0):", (double)this.angle, 1);
        genericDialog.addNumericField("Add Gaussian noise :", (double)this.gnoise, 0);
        genericDialog.addStringField("Path :", this.path, 25);
        genericDialog.addStringField("Name :", this.name, 15);
        genericDialog.addCheckbox("Save parameters file", this.b_save);
        genericDialog.addMessage(this.sCop);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return 0;
        }
        this.ssize = (int)genericDialog.getNextNumber();
        this.resol = (float)genericDialog.getNextNumber();
        this.LCP = (int)genericDialog.getNextNumber();
        this.TCP = (int)genericDialog.getNextNumber();
        this.HCS = (float)genericDialog.getNextNumber();
        this.WCS = (float)genericDialog.getNextNumber();
        this.period = (float)genericDialog.getNextNumber();
        this.amp = (int)genericDialog.getNextNumber();
        this.level = (int)genericDialog.getNextNumber();
        this.org_lvl = (int)genericDialog.getNextNumber();
        this.angle = (float)genericDialog.getNextNumber();
        this.gnoise = (int)genericDialog.getNextNumber();
        this.path = genericDialog.getNextString();
        this.name = genericDialog.getNextString();
        this.b_save = genericDialog.getNextBoolean();
        return 1;
    }
}

