/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamProcessor;

public abstract class WebcamTask {
    private boolean sync = true;
    private WebcamProcessor processor = null;
    private WebcamDevice device = null;
    private Throwable throwable = null;

    public WebcamTask(WebcamDriver driver, WebcamDevice device) {
        if (driver == null) {
            throw new IllegalArgumentException("Webcam driver argument cannot be null");
        }
        this.sync = !driver.isThreadSafe();
        this.device = device;
        this.processor = WebcamProcessor.getInstance();
    }

    public WebcamDevice getDevice() {
        return this.device;
    }

    public void process() throws InterruptedException {
        if (this.sync) {
            if (this.processor == null) {
                throw new RuntimeException("Driver should be synchronized, but processor is null");
            }
            this.processor.process(this);
        } else {
            this.handle();
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable t) {
        this.throwable = t;
    }

    protected abstract void handle();
}

