/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamExceptionHandler;
import com.github.sarxos.webcam.WebcamTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class WebcamProcessor {
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private static final ExecutorService runner = Executors.newSingleThreadExecutor(new ProcessorThreadFactory());
    private static final AtomicProcessor processor = new AtomicProcessor();
    private static final WebcamProcessor INSTANCE = new WebcamProcessor();

    private WebcamProcessor() {
    }

    public void process(WebcamTask task) throws InterruptedException {
        if (started.compareAndSet(false, true)) {
            runner.execute(processor);
        }
        if (runner.isShutdown()) {
            throw new RejectedExecutionException("Cannot process because processor runner has been already shut down");
        }
        processor.process(task);
    }

    public static synchronized WebcamProcessor getInstance() {
        return INSTANCE;
    }

    private static final class AtomicProcessor
    implements Runnable {
        private SynchronousQueue<WebcamTask> inbound = new SynchronousQueue(true);
        private SynchronousQueue<WebcamTask> outbound = new SynchronousQueue(true);

        private AtomicProcessor() {
        }

        public void process(WebcamTask task) throws InterruptedException {
            this.inbound.put(task);
            Throwable t = this.outbound.take().getThrowable();
            if (t != null) {
                throw new WebcamException("Cannot execute task", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WebcamTask t = null;
                try {
                    t = this.inbound.take();
                    t.handle();
                    continue;
                }
                catch (InterruptedException e) {
                    if (t == null) break;
                    try {
                        this.outbound.put(t);
                    }
                    catch (InterruptedException e2) {
                    }
                    catch (Exception e3) {
                        throw new RuntimeException("Cannot put task into outbound queue", e3);
                    }
                }
                catch (Throwable e) {
                    t.setThrowable(e);
                    continue;
                }
                finally {
                    if (t == null) continue;
                    try {
                        this.outbound.put(t);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot put task into outbound queue", e);
                    }
                    continue;
                }
                break;
            }
        }
    }

    private static final class ProcessorThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger N = new AtomicInteger(0);

        private ProcessorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, String.format("atomic-processor-%d", N.incrementAndGet()));
            t.setUncaughtExceptionHandler(WebcamExceptionHandler.getInstance());
            t.setDaemon(true);
            return t;
        }
    }
}

