/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamExceptionHandler;
import com.github.sarxos.webcam.WebcamLockException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamLock {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamLock.class);
    private static final Object MUTEX = new Object();
    private static final long INTERVAL = 2000L;
    private final Webcam webcam;
    private Thread updater = null;
    private AtomicBoolean locked = new AtomicBoolean(false);
    private File lock = null;

    protected WebcamLock(Webcam webcam) {
        this.webcam = webcam;
        this.lock = new File(System.getProperty("java.io.tmpdir"), this.getLockName());
    }

    private String getLockName() {
        return String.format(".webcam-lock-%d", Math.abs(this.webcam.getName().hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(long value) {
        String name = this.getLockName();
        File tmp = null;
        FilterOutputStream dos = null;
        try {
            tmp = File.createTempFile(name, "");
            dos = new DataOutputStream(new FileOutputStream(tmp));
            ((DataOutputStream)dos).writeLong(value);
            ((DataOutputStream)dos).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!this.locked.get()) {
            return;
        }
        if (tmp.renameTo(this.lock)) {
            return;
        }
        if (!this.lock.exists()) {
            try {
                if (!this.lock.createNewFile()) {
                    throw new RuntimeException("Not able to create file " + this.lock);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        FileOutputStream fos = null;
        FileInputStream fis = null;
        int k = 0;
        int n = -1;
        byte[] buffer = new byte[8];
        boolean rewritten = false;
        Object object = MUTEX;
        synchronized (object) {
            do {
                try {
                    fos = new FileOutputStream(this.lock);
                    fis = new FileInputStream(tmp);
                    while ((n = fis.read(buffer)) != -1) {
                        fos.write(buffer, 0, n);
                    }
                    rewritten = true;
                }
                catch (IOException e) {
                    LOG.debug("Not able to rewrite lock file", (Throwable)e);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            } while (!rewritten && k++ < 5);
        }
        if (!rewritten) {
            throw new WebcamException("Not able to write lock file");
        }
        if (!tmp.delete()) {
            tmp.deleteOnExit();
        }
    }

    private long read() {
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(this.lock));
            long l = ((DataInputStream)dis).readLong();
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void update() {
        this.write(System.currentTimeMillis());
    }

    public void lock() {
        if (this.isLocked()) {
            throw new WebcamLockException(String.format("Webcam %s has already been locked", this.webcam.getName()));
        }
        if (!this.locked.compareAndSet(false, true)) {
            return;
        }
        LOG.debug("Lock {}", (Object)this.webcam);
        this.update();
        this.updater = new LockUpdater();
        this.updater.start();
    }

    public void unlock() {
        if (!this.locked.compareAndSet(true, false)) {
            return;
        }
        LOG.debug("Unlock {}", (Object)this.webcam);
        this.updater.interrupt();
        this.write(-1L);
        if (!this.lock.delete()) {
            this.lock.deleteOnExit();
        }
    }

    public boolean isLocked() {
        if (this.locked.get()) {
            return true;
        }
        if (!this.lock.exists()) {
            return false;
        }
        long now = System.currentTimeMillis();
        long tsp = this.read();
        LOG.trace("Lock timestamp {} now {} for {}", new Object[]{tsp, now, this.webcam});
        return tsp > now - 4000L;
    }

    private class LockUpdater
    extends Thread {
        public LockUpdater() {
            this.setName(String.format("webcam-lock-[%s]", WebcamLock.this.webcam.getName()));
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(WebcamExceptionHandler.getInstance());
        }

        @Override
        public void run() {
            do {
                WebcamLock.this.update();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    LOG.debug("Lock updater has been interrupted");
                    return;
                }
            } while (WebcamLock.this.locked.get());
        }
    }
}

