/*//////////////////////////////////////////////////////////////////
//  This file is part of IJ_IDS_Cam plugin for ImageJ.
//
//  IJ_IDS_Cam is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  IJ_IDS_Cam is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with IJ_IDS_Cam.  If not, see <http://www.gnu.org/licenses/>.
//
// Copyright 2014-2017 Francois GANNIER, Come PASQUALIN
/////////////////////////////////////////////////////////////////*/

import ij.*;
import ij.plugin.*;
import ij.process.*;
import ij.gui.*;		// genericDialog, Roi
import ij.Prefs;		//Prefs.get
import ij.measure.Calibration;

import java.io.*;
import java.util.*;
import java.util.List;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.AffineTransform; //rotation text

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.Memory;
import com.sun.jna.Structure;
import com.sun.jna.ptr.*;

import com.sun.jna.platform.*;
import com.sun.jna.platform.win32.*;
import com.sun.jna.platform.win32.WinNT.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.UIManager.LookAndFeelInfo;


/* v0.2
// add 16 bits support
// add work now at full camera speed
// need jna-platform library
//v1.0
// add compatibility with jna 4.2
//v1.1
// new Dialogbox
// compatibility linux/windows
// multi-cam management
// RGB mode
// subSampling Management
// Shutter Auto
// Slider for Shutter
// data transfert bandwidth display
// add keylistener
// add Pause and Snap acquisition
// add Zoom_to_AOI
// add set AOI from ROI
// add set AES/AGC on ROI
// add Brightness reference
// add White balance auto on Color Camera

//v1.2
// add Pause, Snap and Stacks acquisition
// Free Memory Management for saving
// add help info ???

//v1.3
// fix FPS not update with AOI change
// add RGB control for color camera
// add Stop visualisation to avoid lossing images during high speed acquisition
// add timestamp (in microsec) to each image
*/

//WindowListener
public class IJ_IDS_Cam implements PlugIn, KeyListener, ChangeListener, ActionListener, ItemListener, ImageListener {
	boolean debug = true;
	
    ImageWindow win;
    ImageCanvas canvas;
	
	String sVer="IDS Cam Control ver. 1.3";
	String sCop="Copyright \u00A9 2015-2018 F.GANNIER - C.PASQUALIN";

	public static final int IS_SUCCESS = 0;
	public static final int IS_NO_SUCCESS = -1;

	public static final int IS_GET_BINNING 				= 0x8000;
	public static final int IS_GET_SUPPORTED_BINNING 	= 0x8001;
	public static final int IS_BINNING_2X				= 0x0003;
	public static final int IS_BINNING_3X				= 0x0030;
	public static final int IS_BINNING_4X				= 0x000C;
	public static final int IS_BINNING_5X				= 0x00C0;
	public static final int IS_BINNING_6X				= 0x0300;
	public static final int IS_BINNING_8X				= 0x0C00;
	public static final int IS_BINNING_16X				= 0x3000;
	
	public static final int IS_GET_SUBSAMPLING				= 0x8000;
	public static final int IS_GET_SUPPORTED_SUBSAMPLING	= 0x8001;
	public static final int IS_SUBSAMPLING_2X		    	= 0x0003;
	public static final int IS_SUBSAMPLING_4X			  	= 0x000C;
	public static final int IS_SUBSAMPLING_3X			  	= 0x0030;
	public static final int IS_SUBSAMPLING_5X				= 0x00C0;
	public static final int IS_SUBSAMPLING_6X   			= 0x0300;
	public static final int IS_SUBSAMPLING_8X   			= 0x0C00;
	public static final int IS_SUBSAMPLING_16X   			= 0x3000;

	public static final int IS_CM_SENSOR_RAW8			= 11;
	public static final int IS_CM_MONO8					= 6;
	public static final int IS_CM_SENSOR_RAW10			= 33;
	public static final int IS_CM_MONO10				= 34;
	public static final int IS_CM_MONO12				= 26;
	public static final int IS_CM_SENSOR_RAW12			= 27;
	public static final int IS_CM_MONO16				= 28;
	public static final int IS_CM_SENSOR_RAW16			= 29;
	public static final int IS_CM_BGRA8_PACKED			= 0x0080;
	public static final int IS_CM_RGBA8_PACKED			= 0x0000;

	public static final int IS_SET_EVENT_FRAME			= 2;

	public static final int IS_SET_AUTO_REFERENCE		= 0x8000;
	public static final int IS_GET_AUTO_REFERENCE		= 0x8001;
	public static final int IS_SET_ENABLE_AUTO_GAIN     = 0x8800;
	public static final int IS_GET_ENABLE_AUTO_GAIN		= 0x8801;
	public static final int IS_SET_ENABLE_AUTO_SHUTTER  = 0x8802;
	public static final int IS_SET_ENABLE_AUTO_WHITEBALANCE  = 0x8804;
	public static final int IS_SET_ENABLE_AUTO_FRAMERATE = 0x8806;
	public static final int IS_SET_ENABLE_AUTO_SENSOR_GAIN = 0x8808;
	public static final int IS_SET_ENABLE_AUTO_SENSOR_SHUTTER = 0x8810;
	public static final int IS_SET_ENABLE_AUTO_SENSOR_GAIN_SHUTTER = 0x8812;
	public static final int IS_SET_ENABLE_AUTO_SENSOR_FRAMERATE = 0x8814;
	public static final int IS_SET_ENABLE_AUTO_SENSOR_WHITEBALANCE = 0x8816;

	public static final int IS_USE_DEVICE_ID            = 0x8000;
	public static class CAMLIST {  
		public static class CAMINFO {
			public int		camID;
			public int		devID;
			public int 		sensorID;
			public boolean	inUse;
			public String 	SerNo; 	//	byte[]	SerNo = new byte[16];
			public String 	Model;	// 	byte[]	Model = new byte[16];
			// public int		Status;
			// public byte[]  	Reserved = new byte[2];
//			public String 	ModelName; //byte[]	ModelName = new byte[32];
			// public byte[]  	Reserved2 = new byte[5];
			public CAMINFO next;
			CAMINFO(int a, int b, int c, boolean d, String s1, String s2) {
				camID = a;	devID = b; sensorID = c; inUse = d;
				SerNo = s1; Model = s2; // Status = e;
				next = null;
			}
		}
		protected CAMINFO first;
		protected CAMINFO last;
		public CAMLIST() {
			first = null;
		}
		public boolean isEmpty() { return (first == null); }
		public void add(int a, int b, int c, boolean d, String s1, String s2) {
			CAMINFO p = new CAMINFO(a,b,c,d,s1,s2);
			if (isEmpty()) first = p;
			else last.next = p;
			last = p;
		}
		public String getString(int n) {
			CAMINFO current=first;
			while ( n != 0) { 
				if (current.next != null)
					current = current.next; 
				else return "error";
				n--;
			}
			if (current != null)
				return " " + current.Model + current.SerNo + (current.inUse?"in use":"ready");
			return "error";			
		}
		public int getDevID(int n) {
			CAMINFO current=first;
			while ( n != 0) { 
				if (current.next != null)
					current = current.next; 
				else return 0;
				n--;
			}
			if (current != null)
				return current.devID;
			return 0;
		}
	}
	
//  native method declarations (wrapping)
	public interface UEYE extends Library {
		public static class IS_SIZE2D extends Structure {
			public static class ByReference extends IS_SIZE2D implements Structure.ByReference {}
			public int Width;
			public int Height;
			@Override
			protected List getFieldOrder() {
				return Arrays.asList("Width","Height");
			}
		}
		public static class RECT extends Structure {
			public static class ByReference extends RECT implements Structure.ByReference {}
			public int x;
			public int y;
			public int cx;
			public int cy;
			@Override
			protected List getFieldOrder() {
				return Arrays.asList("x","y","cx","cy");
			}
		}

		public static class CAMINFO extends Structure {  
			public static class ByReference extends CAMINFO implements Structure.ByReference {}
			public byte[]	strSerNo = new byte[12];    // e.g. ""
			public byte[]	strID = new byte[20];  	  	// e.g. "IDS GmbH"
			public byte[]	strVersion = new byte[10];	// e.g. "v2.10"
			public byte[]	strDate = new byte[12];  	// DD.MM.YYYY
			public byte 	Select;               		// CamID
			public byte     Type;
			public byte[]   Reserved = new byte[8];
			@Override
			protected List getFieldOrder() {
				return Arrays.asList("strSerNo","strID","strVersion","strDate","Select","Type","Reserved");
			}
		}

		public static class SENSORINFO extends Structure {  	// http://stackoverflow.com/questions/19455366/struct-with-array-of-structs-jna
											// http://stackoverflow.com/questions/15430260/returning-and-accessing-array-of-object-of-structure-in-jna
			public static class ByReference extends SENSORINFO implements Structure.ByReference {}
			public short 	SensorID;               		// e.g. IS_SENSOéR_UI224X_C
			public byte[]   strSensorName = new byte[32];      	// e.g. "UI-224X-C"
			public byte       nColorMode;             		// e.g. IS_COLORMODE_BAYER
			public int        nMaxWidth;              		// e.g. 1280
			public int        nMaxHeight;             		// e.g. 1024
			public boolean    bMasterGain;            		// e.g. TRUE
			public boolean    bRGain;                 		// e.g. TRUE
			public boolean    bGGain;                 		// e.g. TRUE
			public boolean    bBGain;                 		// e.g. TRUE
			public boolean    bGlobShutter;           		// e.g. TRUE
			public short      wPixelSize;             		// e.g. 465 = 4.65 um
			public byte       nUpperLeftBayerPixel;   		// e.g. BAYER_PIXEL_RED (value = 0)
			public byte[]     Reserved = new byte[13];
			@Override
			protected List getFieldOrder() {
				return Arrays.asList("SensorID","strSensorName","nColorMode","nMaxWidth","nMaxHeight","bMasterGain","bRGain","bGGain","bBGain","bGlobShutter",
				"wPixelSize","nUpperLeftBayerPixel","Reserved");
			}
		}
		public int is_GetDLLVersion();										// IDSEXP is_GetDLLVersion(void);
			// INT is_GetUsedBandwidth (HIDS hCam)
		public int is_GetUsedBandwidth(int hCam); 
		public int is_GetNumberOfCameras(IntByReference NumCam); 			// IDSEXP is_GetNumberOfCameras (INT* pnNumCams);
		public int is_InitCamera(IntByReference phCam, Pointer window); 	// IDSEXP is_InitCamera (HIDS* phCam, HWND hWnd);
		public int is_ExitCamera(int hCam);									// IDSEXP is_ExitCamera (HIDS hCam);
		public int is_StopLiveVideo(int hCam, int Wait);
		public int is_FreezeVideo(int hCam, int Wait);
									// IDSEXP is_ImageFormat (HIDS hCam, UINT nCommand, void *pParam, UINT nSizeOfParam);
		public int is_ImageFormat(int hCam, int nCommand, Pointer pParam, int nSizeOfParam);
		public int is_GetColorDepth(int hCam, IntByReference pnCol, IntByReference pnColMode);
		public int is_SetColorMode(int hCam, int Mode);
									// IDSEXP is_PixelClock(HIDS hCam, UINT nCommand, void* pParam, UINT cbSizeOfParam)
		public int is_PixelClock(int hCam, int nCommand, Pointer pParam, int cbSizeOfParam);
									// INT is_SetOptimalCameraTiming (HIDS hCam, INT Mode, INT Timeout, INT* pMaxPxlClk, double* pMaxFrameRate)
		// public int is_SetOptimalCameraTiming (int hCam, int Mode, int Timeout,IntByReference pMaxPxlClk, DoubleByReference pMaxFrameRate);
		// public int is_ClearSequence (int hCam);
		// public int is_AddToSequence (int hCam, Pointer pcImgMem, int nID); //char *
		// public int is_LockSeqBuf (int hCam, int nNum, Pointer pcMem);
									// IDSEXP   is_SetImageMem (HIDS hCam, char* pcMem, int id);
		public int is_SetImageMem(int hCam, Pointer pcImgMem, int id);
									// INT is_CopyImageMem (HIDS hCam, char* pcSource, INT nID, char* pcDest)
//		public int is_CopyImageMem(int hCam, ByteByReference pcSource, int nID, ByteByReference pcDest);
									// INT is_SetBinning (HIDS hCam, INT mode)
		public int is_SetBinning (int hcam, int mode);
									// INT is_SetSubSampling (HIDS hCam, INT mode)
		public int is_SetSubSampling (int hcam, int mode);
									//  INT is_GetBusSpeed (HIDS hCam)
		public int is_GetBusSpeed(int hcam);
		public int is_Configuration (int nCommand, Pointer pParam, int cbSizeOfParam);
									// INT is_SetHWGainFactor (HIDS hCam, INT nMode, INT nFactor)
		public int is_SetHWGainFactor(int hCam, int nMode, int nFactor);
									// INT is_SetAutoParameter (HIDS hCam, INT param, double* pval1, double* pval2)
		public int is_SetAutoParameter(int hCam, int param, DoubleByReference pval1, DoubleByReference pval2);

		public int is_SetGainBoost(int hCam, int mode);

		public int is_ResetToDefault (int hCam);
		public int is_CaptureVideo(int hCam, int Wait);
									//INT is_SetDisplayMode(HIDS hCam, INT Mode)
		public int is_SetDisplayMode(int hCam, int Mode);
									// INT is_SetFrameRate (HIDS hCam, double FPS, double* newFPS)
		public int is_SetFrameRate(int hCam, double FPS, DoubleByReference newFPS);
									//INT is_Exposure (HIDS hCam, UINT nCommand, void* pParam, UINT cbSizeOfParam)
		public int is_Exposure(int hCam, int nCommand, Pointer pParam, int cbSizeOfParam);
									//INT is_GetFrameTimeRange (HIDS hCam, double* min, double* max, double* intervall)
		public int is_GetFrameTimeRange(int hCam, DoubleByReference minFPS, DoubleByReference maxFPS, DoubleByReference intFPS);
									//INT is_GetFramesPerSecond (HIDS hCam, double* dblFPS)
		public int is_GetFramesPerSecond (int hCam, DoubleByReference dblFPS);
									// IDSEXP   is_SetImageSize(HIDS hf, INT x, INT y);
		public int is_SetImageSize(int hcam, int x, int y);
									// IDSEXP is_AOI(HIDS hCam, UINT nCommand, void *pParam, UINT SizeOfParam);
		public int is_AOI (int hCam, int nCommand, Pointer pParam, int nSizeOfParam);
//		public int is_AOI (int hCam, int nCommand, IS_SIZE2D pParam, int nSizeOfParam);
									// INT is_GetSensorInfo (HIDS hCam, SENSORINFO* pInfo)
		public int is_GetSensorInfo(int hCam, UEYE.SENSORINFO.ByReference pInfo);
									// INT is_GetCameraList (UEYE_CAMERA_LIST* pucl)
		public int is_GetCameraList(byte[] buf);
		
							// ULONG is_CameraStatus (HIDS hCam, INT nInfo, ULONG ulValue)
		public long is_CameraStatus (int hCam, int nInfo, long ulValue);
									//INT is_GetCameraInfo (HIDS hCam, CAMINFO* pInfo)
		public int is_GetCameraInfo (int hCam, UEYE.CAMINFO.ByReference pInfo);
									// IDSEXP is_AllocImageMem(HIDS hCam, INT width, INT height, INT bitspixel, char** ppcImgMem, int* pid);
		public int is_AllocImageMem(int hCam, int width, int height, int bitspixel,
					PointerByReference ppcImgMem, IntByReference pid);
									//IDSEXP  is_SetAllocatedImageMem   (HIDS hCam, INT width, INT height, INT bitspixel, char* pcImgMem, int* pid);
		public int is_SetAllocatedImageMem (int hCam, int width, int height, int bitspixel,
					ByteByReference pcImgMem, IntByReference  pid);
									//  IDSEXP   is_FreeImageMem(HIDS hCam, char* pcMem, int id);
		public int is_FreeImageMem(int hCam, Pointer pcImgMem, int id);	// char *

									// IDSEXP is_WaitForNextImage            (HIDS hCam, UINT timeout, char **ppcMem, INT *imageID);
		public int is_WaitForNextImage(int hCam, int timeout, PointerByReference ppcImgMem, IntByReference pid);
/*		public int is_SetAllocatedImageMem(IntByReference phCam,
			int width, int height, int bitspixel,
                       byte* pcImgMem, int* pid)/**/
//		public int is_LoadParameters(IntByReference phf, String fileName);
//		public int is_GetActiveImageMem (int cameraHandle, PointerByReference buffer, IntByReference memoryId);

			//INT is_IO(HIDS hCam, UINT nCommand, void* pParam, UINT cbSizeOfParam)
		public int is_IO(int hCam, int command, Pointer pParam, int cbsize);
		public int is_InitEvent (int hCam, HANDLE hevent, int id);
		public int is_WaitEvent (int hCam, int which, int nTimeout);
		public int is_EnableEvent (int hCam, int which);
		public int is_DisableEvent (int hCam, int which);
		public int is_ExitEvent (int hCam, int which);
	}
	UEYE ueye;// = (UEYE)Native.loadLibrary("ueye_api", UEYE.class); //libueye_api.so

	ImagePlus imp;
	ImageProcessor ip;
	ImageStack ist;
	HANDLE hEvent;
	boolean Active=false;
// sync : init
	listenCOM sync = null;
	boolean syncSupp;
	boolean RTSsync = false; // true;
	int comPort	= 1;
	
	byte[] pix8;
	short[] pix16;
	int[] pix32;
	boolean console = false; // true;

	String st;
	int NumCam = -1;
	int MaxWidth = -1;
	int MaxHeight = -1;
	int	vDiv = 1;
	int	hDiv = 1;
	
	String ModelName;
	int usb=0;
	int setCM		= IS_CM_MONO8;
	String stCM 	= "8-bit Black";
	int bitspixel = 8;
	int uBytesPerPixel;		// = (bitspixel+7)/8;
	int uImageSize;			// = Width * Height * uBytesPerPixel;
	boolean AOIsupp = false;
	int binningMode = -1;
	int binningSupp = -1;
	int subSamplingMode = -1;
	int subSamplingSupp = -1;
	boolean boostGainSupp = false;
	boolean boostGain = false;
	boolean color = false;
	int Nbinning	= 0;
	int NsubSampling = 0;
	int setBinning 	= 0;
	int setsubSampling = 0;
	int setDiv 		= 1;
	int nImage		= 0;
	
	private int gain = 200;
	private int Rgain = 142;
	private int Ggain = 104;
	private int Bgain = 375;
	
	double calib = 1;
	String unit = "micron";
	boolean calibChanged = false;
	boolean autoGain = true;
	boolean bHide = false;
//	boolean bStamp = true;
// autoShutter	
	boolean autoShutter = true;
	boolean autoWB = false;
	boolean ListCam = false;
	boolean bSync = false;
	boolean bplay = true, bsav = false;

	boolean cb_sync = true;
	boolean cb_top = true;
	boolean cb_vidAcq =false;
	boolean cb_snap = false;
	boolean cb_proto= false;
	int	proto_periode=10; 		//en s
	
	int delay = 0;
	boolean cb_beep = true;
	boolean cb_dtr = false;
	int cbi_rts = 0;
	int cbi_led = 0;
	boolean cb_syncbip = false;
	
	int nVideo=0;
	int expFPS = 25;
	
	IntByReference pPxlClk = new IntByReference();
	Pointer arrayClock;
	int maxClock;
	int minClock;
	int incClock;
	int nbInc;
	
	static int  DLL_VER_MAJOR = 4;
	static int  DLL_VER_MINOR = 6;

	IntByReference pHIDS;
	PointerByReference ppcImgMem;
	Pointer pcImgMem;
	IntByReference pid;
	DoubleByReference enable = new DoubleByReference();
	DoubleByReference disable = new DoubleByReference();
	DoubleByReference dblFPS = new DoubleByReference();
	
	int Skip_Frame_max;
	int Skip_Frame_min;

	UEYE.IS_SIZE2D ImgSize;
	UEYE.RECT AOI_rect;
	UEYE.IS_SIZE2D AOI_pos_inc;
	UEYE.IS_SIZE2D AOI_size_inc; /* */
	UEYE.IS_SIZE2D AOI_pos_min;
	UEYE.IS_SIZE2D AOI_size_min;
	
	long MaxImage;
	long StartTime;
	boolean end = false;
	boolean SPACE = false;
	
	private static String OS = System.getProperty("os.name").toLowerCase();
    public static boolean isWindows() {
        return (OS.indexOf("win") >= 0);
    }

	public static boolean isPresent(String className) {
		try {
			Class.forName(className);
			return true;
		} catch (Throwable ex) {
			// Class or one of its dependencies is not present...
			return false;
		}
	}/* */
		
    // Valid values are: null (use the default), "Metal", "System", "Motif", and "GTK" "Nimbus"
    String LOOKANDFEEL = "Nimbus";
    private void initLookAndFeel() {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                try {
                    for (LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
						if (debug) Display(info.getName());
                        if (LOOKANDFEEL.equals(info.getName())) {
                            UIManager.setLookAndFeel(info.getClassName());
                            break;
                        }
                    }
                } catch (Exception e) {
                    // If Nimbus is not available, you can set the GUI to another look and feel.
                }
            }
		});
    }
	
	protected JSlider sl_gain, sl_expFPS, sl_pxlclk, sl_expTime, sl_AOIX, sl_AOIY, sl_AOICX, sl_AOICY, sl_brightRef,	sl_image,	sl_time;
	protected JTextField lb_gain, lb_expFPS, lb_pxlclk, lb_expTime, lb_AOIX, lb_AOIY, lb_AOICX, lb_AOICY, lb_brightRef, lb_image,	lb_time;
	
	protected JSlider sl_Rgain,sl_Bgain,sl_Ggain;
	protected JTextField lb_Rgain,lb_Bgain,lb_Ggain;
	
	
	JSlider addSlider(JPanel panel, String Name, JTextField val, int minV, int max, int dflt) {
		JSlider slider = new JSlider();
        slider = new JSlider(SwingConstants.HORIZONTAL, minV, max, (dflt<max?dflt:max)); //max, value
        slider.setMinorTickSpacing((max-minV)/10);
        slider.setMajorTickSpacing((max-minV)/2);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
		
		JPanel ValPanel = new JPanel();
		ValPanel.setLayout(new FlowLayout(FlowLayout.TRAILING, 5, 3));
        Label label = new Label(Name);	//, Label.CENTER);
		ValPanel.add(label);

		val.setHorizontalAlignment(JTextField.CENTER);
		// val.setEditable(false);
		val.setText(""+(dflt<max?dflt:max));
		val.addActionListener(this);
		ValPanel.add(val);
		
		panel.add(ValPanel);
		panel.add(slider);
		slider.addChangeListener(this);
		return slider;
	}
	
	protected JCheckBox bxGain, bxBoost, bxShutter, bxHide;
	public JCheckBox addCheckBox(JPanel panel, String Name, boolean dflt) 	{
		JCheckBox bxTemp = new JCheckBox(Name, dflt);
		panel.add(bxTemp);
		bxTemp.addItemListener(this);
		return bxTemp;
	}
	
	protected String getSpeed() {
		int debit = (uBytesPerPixel*uImageSize*expFPS)/900;
		if (debit >10000)
			return ""+debit/1000 + "MB/s (USB"+usb+")";
		else return ""+debit + "KB/s (USB"+usb+")";
	}
	
	protected void TF_enable(boolean b, JTextField TF) {
		TF.setEditable(b);
		TF.setForeground(b?null:Color.LIGHT_GRAY); //DARK_GRAY);
		// TF.setBackground(b?null:Color.LIGHT_GRAY); //LIGHT_GRAY);
	}
	
	protected JDialog dialog;
	protected JLabel lb_FPS, sb_left, sb_center;
	protected JButton bt_right;
	private void setSlider(JTextField tf, JSlider sl) {
		String st = tf.getText();
		int oldval = sl.getValue();
		int newval=0;
		try{
			newval = Integer.parseInt(st);
		}catch(NumberFormatException error){
			tf.setText(""+oldval);
			return;
		}			
		int min = sl.getMinimum();
		int max = sl.getMaximum();
		if (newval>=min && newval<=max) {
			if (newval != oldval) 
				sl.setValue(newval);
		} else tf.setText(""+oldval);
	}
	
	public void actionPerformed(ActionEvent e) {
		Object origin=e.getSource();
		if (origin==lb_gain) setSlider(lb_gain, sl_gain);

		if (origin==lb_Rgain) setSlider(lb_Rgain, sl_Rgain);
		if (origin==lb_Ggain) setSlider(lb_Ggain, sl_Ggain);
		if (origin==lb_Bgain) setSlider(lb_Bgain, sl_Bgain);
		
		if (origin==lb_expFPS) setSlider(lb_expFPS, sl_expFPS);
		if (origin==lb_pxlclk) setSlider(lb_pxlclk, sl_pxlclk);
		if (origin==lb_expTime) setSlider(lb_expTime, sl_expTime);
		if (origin==lb_AOIX) setSlider(lb_AOIX, sl_AOIX);
		if (origin==lb_AOIY) setSlider(lb_AOIY, sl_AOIY);
		if (origin==lb_AOICX) setSlider(lb_AOICX, sl_AOICX);
		if (origin==lb_AOICY) setSlider(lb_AOICY, sl_AOICY);
		if (origin==lb_brightRef) setSlider(lb_brightRef, sl_brightRef);
		
		if (origin==lb_time) {
			setSlider(lb_time, sl_time);
			int val = (int) (sl_time.getValue()*dblFPS.getValue());
			lb_image.setText(""+val );
			sl_image.setValue(val);
			
		}
		if (origin==lb_image) {
			setSlider(lb_image, sl_image);
			int val = (int) (sl_image.getValue()/dblFPS.getValue());
			lb_time.setText(""+val);
			sl_time.setValue(val);
		}
		
		if (origin==bt_right) {
 			GenericDialog gd = new GenericDialog("Set sync options");
			{
				gd.setInsets(5, 5, 0); 	//top, left, bottom - see default
				gd.addMessage("DSR IN pulse");
				gd.setInsets(0, 20, 0); 
				gd.addCheckbox("Add metadata \"sync\" to image", cb_sync);
				gd.addCheckbox("beep", cb_syncbip);
				
				gd.setInsets(15, 5, 0); 	//top, left,bottom
				gd.addMessage("CTS IN pulse");
				gd.addCheckbox("Add metadata \"top\" to image", cb_top);
				gd.addCheckbox("Start/Stop video Acquisition", cb_vidAcq);
				gd.addCheckbox("Take a picture", cb_snap);
					gd.addNumericField("    With a delay of", delay, 0, 3, "s");
				gd.addCheckbox("beep", cb_beep);
				
				String[] choice1 = new String[4];
				int n = 0;
				choice1[n++] = "do nothing";
				choice1[n++] = "switch at  each new image";
				choice1[n++] = "switch at  each new sync on DSR";
				choice1[n++] = "when recording video";
				gd.setInsets(15, 5, 0); 	//top, left,bottom
				gd.addChoice("RTS OUT pulse", choice1, choice1[cbi_rts]);

				gd.setInsets(15, 5, 0); 	//top, left,bottom
				gd.addMessage("DTR OUT pulse");
				gd.addMessage("Add metadata \"mark\" to image when SPACE is pressed");
				gd.addCheckbox("When SPACE is pressed", cb_dtr);
				gd.addCheckbox("Active Proto with SPACE", cb_proto);
				gd.addNumericField("    With a periode of", proto_periode, 0, 3, "s");
				
				String[] choice0 = new String[3];
				n = 0;
				choice0[n++] = "do nothing";
				choice0[n++] = "each new image";
				choice0[n++] = "each sync on DSR";
				gd.setInsets(15, 5, 0); 	//top, left,bottom
				gd.addChoice("Flash Camera led", choice0, choice0[cbi_led]);
				
			}
			gd.showDialog(); 
			cb_sync = gd.getNextBoolean();
			cb_syncbip = gd.getNextBoolean();
			cb_top  = gd.getNextBoolean();
			cb_vidAcq = gd.getNextBoolean();
			cb_snap = gd.getNextBoolean();
			delay = (int) gd.getNextNumber();
			cb_beep = gd.getNextBoolean();
			cbi_rts = gd.getNextChoiceIndex();
			cb_dtr = gd.getNextBoolean();
			cb_proto = gd.getNextBoolean();
			proto_periode = (int) gd.getNextNumber();
			cbi_led = gd.getNextChoiceIndex();
			
		} /* */
	}
	public void itemStateChanged(ItemEvent e){
		Object origin=e.getSource();
       // boolean checked=e.getStateChange()==1?true:false;
		if (origin==bxShutter) {
			autoShutter = bxShutter.isSelected();
			if (autoShutter) TF_enable(false, lb_expTime);
			else TF_enable(true, lb_expTime);
			setAutoShutter(autoShutter, sl_expTime.getValue());
		}
		if (origin==bxGain) {
			autoGain = bxGain.isSelected();
			if (autoGain) TF_enable(false, lb_gain);
			else TF_enable(true, lb_gain);
			setAutoGain(autoGain, gain);
		}
		if (origin==bxHide) {
			bHide = bxHide.isSelected();
		}
		
		if (origin==bxBoost) {
			boostGain = bxBoost.isSelected();
			if (boostGain) {
				if (0 == ueye.is_SetGainBoost(pHIDS.getValue(), 0x8008)) // IS_GET_GAINBOOST
					ueye.is_SetGainBoost(pHIDS.getValue(), 1); //IS_SET_GAINBOOST_ON
				} else if (1 == ueye.is_SetGainBoost (pHIDS.getValue(), 0x8008)) // IS_GET_GAINBOOST
					ueye.is_SetGainBoost(pHIDS.getValue(), 0); //IS_SET_GAINBOOST_OFF
			}		
	}
	
	int reentry=0;
	public void stateChanged(ChangeEvent e) {
		Object origin=e.getSource();
		int ret;
		boolean b_ETchge=false, b_FPSchge=false, b_FPSupdate=false;
		reentry++;
		if (reentry>1) { reentry--; return; }		
		if (origin == sl_image) {
			lb_image.setText(""+sl_image.getValue());
			int val = (int) (sl_image.getValue()/dblFPS.getValue());
			lb_time.setText(""+val);
			sl_time.setValue(val);
		}
		if (origin == sl_time) {
			lb_time.setText(""+sl_time.getValue());
			int val = (int) (sl_time.getValue()*dblFPS.getValue());
			lb_image.setText(""+val );
			sl_image.setValue(val);
		}
		
		if (origin == sl_brightRef) {
			DoubleByReference pval = new DoubleByReference();
			pval.setValue((int) sl_brightRef.getValue());
			lb_brightRef.setText(""+pval.getValue());
			ueye.is_SetAutoParameter(pHIDS.getValue(), IS_SET_AUTO_REFERENCE, pval, disable);			
		}
		
		if (origin == sl_gain) {
			gain = sl_gain.getValue();
			lb_gain.setText(""+gain);
			if (!autoGain)
				setAutoGain(autoGain, gain);
		}
		
		if (origin == sl_Rgain) {
			Rgain = sl_Rgain.getValue();
			lb_Rgain.setText(""+Rgain);
			ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8005, Rgain);
		}
		if (origin == sl_Ggain) {
			Ggain = sl_Ggain.getValue();
			lb_Ggain.setText(""+Ggain);
			ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8006, Ggain);
		}		
		if (origin == sl_Bgain) {
			Bgain = sl_Bgain.getValue();
			lb_Bgain.setText(""+Bgain);
			ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8007, Bgain);
		}
		
		if (origin == sl_expFPS) {
			expFPS = sl_expFPS.getValue();
			lb_expFPS.setText(""+expFPS);
			b_ETchge=true; b_FPSchge=true;
		}
		if (origin == sl_pxlclk) {
			int oldValue = pPxlClk.getValue( );
			int i = 0;
			while (oldValue > arrayClock.getInt(4*i)) { 
				i++; 
			}
			// Display("old value : "+arrayClock.getInt(4*i));
			int pxclk = sl_pxlclk.getValue();
			// Display("new value : "+pxclk);
			if (pxclk != oldValue) {
				if (pxclk > arrayClock.getInt(4*i))
					pxclk = arrayClock.getInt(4*(i+1));
				if (pxclk < arrayClock.getInt(4*i))
					pxclk = arrayClock.getInt(4*(i-1)); /* */
				pPxlClk.setValue(pxclk);
				ueye.is_PixelClock(pHIDS.getValue(), 6, pPxlClk.getPointer(), 4); 	//IS_PIXELCLOCK_CMD_SET
			}
			sl_pxlclk.setValue(pxclk);
			lb_pxlclk.setText(""+pxclk);
			b_FPSupdate=true; b_ETchge=true; b_FPSchge=true;
		}
		if (origin == sl_expTime) {
			int expTime = sl_expTime.getValue();
			lb_expTime.setText(""+expTime);
			if (!autoShutter)
				setAutoShutter(autoShutter, expTime);
		}

		UEYE.RECT.ByReference AOI_new = new UEYE.RECT.ByReference();
		if ((origin == sl_AOIX) || (origin == sl_AOIY) || 
			(origin == sl_AOICX) || (origin == sl_AOICY )) {
			int AOIX = sl_AOIX.getValue();
			AOI_new.x = AOIX * AOI_pos_inc.Width;
			int AOIY = sl_AOIY.getValue();
			AOI_new.y = AOIY * AOI_pos_inc.Height;
			int AOICX = sl_AOICX.getValue();
			AOI_new.cx = AOICX * AOI_size_inc.Width;
			int AOICY = sl_AOICY.getValue();
			AOI_new.cy = AOICY * AOI_size_inc.Height;			
			
			if (AOI_new.x+AOI_new.cx > ImgSize.Width) {
				AOI_new.cx = ImgSize.Width - AOI_new.x;
				// AOICX = AOI_new.cx/AOI_size_inc.Width;
				// sl_AOICX.setValue(AOICX);
			}
			if (AOI_new.y+AOI_new.cy > ImgSize.Height) {
				AOI_new.cy = ImgSize.Height - AOI_new.y;
				// AOICY = AOI_new.cy/AOI_size_inc.Height;
				// sl_AOICY.setValue(AOICY);
			}
			lb_AOIX.setText(""+AOIX);
			lb_AOIY.setText(""+AOIY);
			lb_AOICX.setText(""+AOICX);
			lb_AOICY.setText(""+AOICY);

			if (reentry>1) { reentry--; return; }
			ret = set_AOI_Rect(1, AOI_new);		// IS_AOI_IMAGE_SET_AOI
			AOI_rect = AOI_new;
			uImageSize = AOI_rect.cx * AOI_rect.cy; // * uBytesPerPixel; 
			switch(uBytesPerPixel) {
				case 4 : for(int i=0; i < (ImgSize.Width*ImgSize.Height);i++) pix32[i] = 0; break;
				case 2 : for(int i=0; i < (ImgSize.Width*ImgSize.Height);i++) pix16[i] = 0; break;
				case 1 : for(int i=0; i < (ImgSize.Width*ImgSize.Height);i++) pix8[i] = 0; break;
			}			
			b_FPSchge=true; b_FPSupdate=true;
		}
		if (b_FPSupdate) {
			DoubleByReference minFPS = new DoubleByReference();
			DoubleByReference maxFPS = new DoubleByReference();
			DoubleByReference intFPS = new DoubleByReference();
			ret = ueye.is_GetFrameTimeRange(pHIDS.getValue(), minFPS, maxFPS, intFPS);
			int minV =  (int) (1/maxFPS.getValue());
			int maxV =  (int) (1/minFPS.getValue());
			sl_expFPS.setMaximum(maxV);
			sl_expFPS.setMinimum(minV);
			sl_expFPS.setLabelTable(null);
			sl_expFPS.setMinorTickSpacing((maxV-minV)/10);
			sl_expFPS.setMajorTickSpacing((maxV-minV)/2);
			sb_left.setText("Acquiring at " + getSpeed());
		}
		
		if (b_ETchge) {
			DoubleByReference exp = new DoubleByReference();
			ueye.is_Exposure(pHIDS.getValue(), 7, exp.getPointer(), 8);//IS_EXPOSURE_CMD_GET_EXPOSURE
			DoubleByReference expMin = new DoubleByReference();
			DoubleByReference expMax = new DoubleByReference();
			ueye.is_Exposure(pHIDS.getValue(), 3, expMin.getPointer(), 8); //IS_EXPOSURE_CMD_GET_EXPOSURE_RANGE_MIN
			ueye.is_Exposure(pHIDS.getValue(), 3, expMin.getPointer(), 8); //IS_EXPOSURE_CMD_GET_EXPOSURE_RANGE_MIN
			ueye.is_Exposure(pHIDS.getValue(), 4, expMax.getPointer(), 8); //IS_EXPOSURE_CMD_GET_EXPOSURE_RANGE_MAX
			int minV = (int)(1000*expMin.getValue());
			int maxV = (int)(1000*expMax.getValue());
			sl_expTime.setMaximum(maxV);
			sl_expTime.setMinimum(minV);
			sl_expTime.setLabelTable(null);
			sl_expTime.setMinorTickSpacing((maxV-minV)/10);
			sl_expTime.setMajorTickSpacing((maxV-minV)/2);
		}
		
		if (b_FPSchge) {
			if ((expFPS/10 < Skip_Frame_min) && (expFPS/10 > Skip_Frame_min)) {
				DoubleByReference pval = new DoubleByReference();
				pval.setValue(expFPS/10);
				ret = ueye.is_SetAutoParameter(pHIDS.getValue(), 0x8018, pval, disable); // IS_SET_AUTO_SKIPFRAMES
				if (ret != IS_SUCCESS) {
					Display("ERROR - is_SetAuto skipframes : " + ret);
				}
			}
			DoubleByReference pFPS = new DoubleByReference();
			ueye.is_SetFrameRate(pHIDS.getValue(), (double) expFPS, pFPS);
			sb_left.setText("Acquiring at " + getSpeed());
		}
		// Display("max USB bandwidth : " + ueye.is_GetUsedBandwidth(pHIDS.getValue()));
		reentry--;
	}
	
/*	public void propertyChange(PropertyChangeEvent e) {
		Object origin=e.getSource();
		Display("propertyChange !");
	}/* */

	public void showControlDialog() {

		int haut = 550;
		dialog = new JDialog(); 
		ImageIcon img = new ImageIcon(getClass().getResource("/ueye.png"));
		dialog.setIconImage(img.getImage());

		JPanel centerPanel = new JPanel(new BorderLayout());
		JPanel ChkPanel = new JPanel();
		
		bxGain = addCheckBox(ChkPanel, "Gain auto", autoGain);
		bxShutter = addCheckBox(ChkPanel, "Shutter auto", autoShutter);
		
		if (boostGainSupp) {
			bxBoost = addCheckBox(ChkPanel, "Gain Boost", boostGain);
		} else {
			JLabel tp = new JLabel("");
			ChkPanel.add(tp);
		}
		bxHide = addCheckBox(ChkPanel, "Vis. off", bHide);
		centerPanel.add(ChkPanel, BorderLayout.NORTH);

		JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new GridLayout(0, 2));
		
		int maxGain = ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x800c, 100); 
		gain = ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8000, gain);
		
		lb_gain = new JTextField(4);
		sl_gain = addSlider(sliderPanel, "Gain : ", lb_gain, 1, maxGain, gain);
		if (autoGain) TF_enable(false, lb_gain);
		
		if (setCM==IS_CM_RGBA8_PACKED) {
			ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8005, Rgain);
			ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8006, Ggain);
			ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8007, Bgain);			
		}
				
		ueye.is_PixelClock(pHIDS.getValue(), 5, pPxlClk.getPointer(), 4); // IS_PIXELCLOCK_CMD_GET
		lb_expFPS = new JTextField(4);
		DoubleByReference minFPS = new DoubleByReference();
		DoubleByReference maxFPS = new DoubleByReference();
		DoubleByReference intFPS = new DoubleByReference();
		int ret = ueye.is_GetFrameTimeRange(pHIDS.getValue(), minFPS, maxFPS, intFPS);
		Display("Time Range : " + (int)(1/maxFPS.getValue()) + " : " + (int) (1/minFPS.getValue()));
		sl_expFPS = addSlider(sliderPanel, "Expected fps : ", lb_expFPS, (int)(1/maxFPS.getValue()), (int) (1/minFPS.getValue()), expFPS);
		lb_pxlclk = new JTextField(4);
		sl_pxlclk = addSlider(sliderPanel, "Pixel clock : ", lb_pxlclk, minClock, maxClock, pPxlClk.getValue( ));
		
		DoubleByReference exp = new DoubleByReference();
		ueye.is_Exposure(pHIDS.getValue(), 7, exp.getPointer(), 8);	//IS_EXPOSURE_CMD_GET_EXPOSURE
		DoubleByReference expMin = new DoubleByReference();
		DoubleByReference expMax = new DoubleByReference();
		ueye.is_Exposure(pHIDS.getValue(), 3, expMin.getPointer(), 8); //IS_EXPOSURE_CMD_GET_EXPOSURE_RANGE_MIN
		ueye.is_Exposure(pHIDS.getValue(), 3, expMin.getPointer(), 8); //IS_EXPOSURE_CMD_GET_EXPOSURE_RANGE_MIN
		ueye.is_Exposure(pHIDS.getValue(), 4, expMax.getPointer(), 8); //IS_EXPOSURE_CMD_GET_EXPOSURE_RANGE_MAX
		Display("INFO - is_Exposure range " + expMin.getValue() +"-"+expMax.getValue());
		lb_expTime = new JTextField(4);
		sl_expTime = addSlider(sliderPanel, "Exposure time (us) : ", lb_expTime, (int)(1000*expMin.getValue()), (int)(1000*expMax.getValue()), (int) (1000*exp.getValue()));
		if (autoShutter) TF_enable(false, lb_expTime);

		lb_brightRef = new JTextField(4);
		sl_brightRef = addSlider(sliderPanel, "Brightness Ref. : ", lb_brightRef, (int)(0), (int)(255), (int) (128));
		
		
		if (AOIsupp) {
			lb_AOIX = new JTextField(4);
			sl_AOIX = addSlider(sliderPanel, "AOI X step : ", 
				lb_AOIX, AOI_pos_min.Width/AOI_pos_inc.Width, 
				(MaxWidth / hDiv)/AOI_pos_inc.Width, 0);
			lb_AOIY = new JTextField(4);
			sl_AOIY = addSlider(sliderPanel, "AOI Y step : ", 
				lb_AOIY, AOI_pos_min.Height/AOI_pos_inc.Height, 
				(MaxHeight / vDiv)/AOI_pos_inc.Height, 0);
			lb_AOICX = new JTextField(4);
			sl_AOICX = addSlider(sliderPanel, "AOI CX step : ", 
				lb_AOICX, AOI_size_min.Width/AOI_size_inc.Width, 
				(MaxWidth / hDiv)/AOI_size_inc.Width, 
				(MaxWidth / hDiv)/AOI_size_inc.Width);
			lb_AOICY = new JTextField(4);
			sl_AOICY = addSlider(sliderPanel, "AOI CY step : ", 
				lb_AOICY, AOI_size_min.Height/AOI_size_inc.Height, 
				(MaxHeight / vDiv)/AOI_size_inc.Height, 
				(MaxHeight / vDiv)/AOI_size_inc.Height);
		}
		DoubleByReference max = new DoubleByReference();
		DoubleByReference min = new DoubleByReference();
		ueye.is_SetAutoParameter(pHIDS.getValue(), 0x801A, min, max); // IS_GET_AUTO_SKIPFRAMES_RANGE
		Display("INFO : IS_GET_AUTO_SKIPFRAMES_RANGE (" + min.getValue() +","+max.getValue()+")");
		min.setValue(Skip_Frame_min);
		max.setValue(Skip_Frame_max);		

		centerPanel.add(sliderPanel, BorderLayout.CENTER);
		JLabel HelpTxt;
		HelpTxt = new JLabel("<html><center><b>Do not changed Size or ROI during Recording !!!<BR>Shortcut </b>: <b>P</b>ause - <b>S</b>nap - <b>Z</b>oom on <b>A</b>OI - A<b>E</b>S on ROI - Start/Stop <b>R</b>ecording<BR></center></html>", JLabel.CENTER);
		
		dialog.add(HelpTxt, BorderLayout.NORTH);
		centerPanel.add(new JLabel(sCop), BorderLayout.SOUTH);
		dialog.add(centerPanel, BorderLayout.CENTER);
		
		// JButton Lbtn = new JButton(" ");
		// Lbtn.setBorderPainted(false);
		// Lbtn.setFocusPainted(false);
		// Lbtn.setEnabled(false);
		// dialog.add(Lbtn, BorderLayout.WEST);
		
		if (!syncSupp)
			bt_right = new JButton("");
		else {
			bt_right = new JButton("Set Sync Options");
			AffineTransform at = bt_right.getFont().getTransform();
			at.rotate(Math.PI/2);
			Font font = bt_right.getFont().deriveFont(at);
			bt_right.setFont(font);
			bt_right.setVerticalAlignment( SwingConstants.CENTER);

			bt_right.addActionListener(this);
		}
		bt_right.setBorderPainted(false);
		bt_right.setFocusPainted(false);
		if (syncSupp) bt_right.setEnabled(true);
		else bt_right.setEnabled(false);
		dialog.add(bt_right, BorderLayout.EAST);
		
		JStatusBar statusBar = new JStatusBar();
		sb_left = new JLabel("Acquiring at " + getSpeed());
		statusBar.setLeftComponent(sb_left);
 
		sb_center = new JLabel(ModelName.substring(0,14));
		sb_center.setHorizontalAlignment(JLabel.CENTER);
		statusBar.addRightComponent(sb_center);
 
		lb_FPS = new JLabel();
		lb_FPS.setHorizontalAlignment(JLabel.CENTER);
		statusBar.addRightComponent(lb_FPS);
 
		dialog.add(statusBar, BorderLayout.SOUTH);		
		
        dialog.pack();
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation(screen.width-450, screen.height-haut-50);
		
		dialog.setSize(450,haut);
		
        dialog.setTitle(sVer);
		dialog.setModal(false);
		dialog.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);	//DISPOSE_ON_CLOSE);
        dialog.setVisible(true);
	}
	
	protected JDialog colorDiag;
	public void showColorDialog() {
		colorDiag = new JDialog(); 
		ImageIcon img = new ImageIcon(getClass().getResource("/ueye.png"));
		colorDiag.setIconImage(img.getImage());

		JPanel centerPanel = new JPanel(new BorderLayout());
		JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new GridLayout(0, 2));
		
		Rgain = ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8001, Rgain);
		Ggain = ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8002, Ggain);
		Bgain = ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8003, Bgain);

		// ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8005, Rgain);
		// ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8006, Ggain);
		// ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8007, Bgain);
		
		int maxGain = ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x800d, 100);
		lb_Rgain = new JTextField(4);
		sl_Rgain = addSlider(sliderPanel, "Red : ", lb_Rgain, 1, maxGain, Rgain);
		
		maxGain = ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x800e, 100);
		lb_Ggain = new JTextField(4);
		sl_Ggain = addSlider(sliderPanel, "Green : ", lb_Ggain, 1, maxGain, Ggain);		

		maxGain = ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x800f, 100);
		lb_Bgain = new JTextField(4);
		sl_Bgain = addSlider(sliderPanel, "Blue : ", lb_Bgain, 1, maxGain, Bgain);
		
		centerPanel.add(sliderPanel, BorderLayout.CENTER);

		JLabel HelpTxt;
		HelpTxt = new JLabel(" ", JLabel.CENTER);
		// HelpTxt = new JLabel("<html><center><b>Do not changed Size or ROI during Recording !!!<BR>Shortcut </b>: <b>P</b>ause - <b>S</b>nap - <b>Z</b>oom on <b>A</b>OI - A<b>E</b>S on ROI - Start/Stop <b>R</b>ecording<BR></center></html>", JLabel.CENTER);
		
		colorDiag.add(HelpTxt, BorderLayout.NORTH);
//		centerPanel.add(new JLabel(sCop), BorderLayout.SOUTH);
		colorDiag.add(centerPanel, BorderLayout.CENTER);
		
		// JButton Lbtn = new JButton(" ");
		// Lbtn.setBorderPainted(false);
		// Lbtn.setFocusPainted(false);
		// Lbtn.setEnabled(false);
		// colorDiag.add(Lbtn, BorderLayout.WEST);
		
		// JButton bt = new JButton("");
		// bt.setBorderPainted(false);
		// bt.setFocusPainted(false);
		// bt.setEnabled(false);
		// colorDiag.add(bt, BorderLayout.EAST);
		colorDiag.add(new JLabel("  \t  "), BorderLayout.EAST);
		
		JStatusBar statusBar = new JStatusBar();
		// sb_left = new JLabel("Acquiring at " + getSpeed());
		// statusBar.setLeftComponent(sb_left);
		
		statusBar.setLeftComponent(new JLabel(sCop));
		
		// sb_center = new JLabel(ModelName.substring(0,14));
		// sb_center.setHorizontalAlignment(JLabel.CENTER);
		// statusBar.addRightComponent(sb_center);
 
		// lb_FPS = new JLabel();
		// lb_FPS.setHorizontalAlignment(JLabel.CENTER);
		// statusBar.addRightComponent(lb_FPS);
 
		colorDiag.add(statusBar, BorderLayout.SOUTH);
		
        colorDiag.pack();
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        colorDiag.setLocation(screen.width/2, screen.height/2);
		
		colorDiag.setSize(450,200);
		
        colorDiag.setTitle(sVer);
		colorDiag.setModal(false);
		colorDiag.setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);	//DISPOSE_ON_CLOSE);
        colorDiag.setVisible(true);
	}
	
	int showInitDialog() {
		GenericDialog gd = new GenericDialog(sVer);
//      gd.setInsets(0, 20, 0);
//		gd.addNumericField("Calibration for X1:", calib, 8, 12, "\u00B5m/px");
		gd.addNumericField("Calibration for X1:", calib, 8, 12, "unit/px");
		gd.addStringField("unit:", unit);
		gd.addCheckbox("Gain Auto", autoGain);
		if (color)
			gd.addCheckbox("Auto White balance", autoWB);
		gd.addNumericField("Expected FPS", expFPS,0);

		{	// mode 8/10/12/16 bits
			String[] choice0 = new String[5];
			int n = 0;
			choice0[n++] = "Mono 8 bits";
			choice0[n++] = "Mono 10 bits";
			choice0[n++] = "Mono 12 bits";
			choice0[n++] = "Mono 16 bits";
			choice0[n++] = "RGB 8 bits";
			gd.addChoice("Mono / Color Mode", choice0, choice0[0]);
		}
		boolean b_LUT = false;
		// gd.addCheckbox("Active internal LUT/gamma", b_LUT);
		if(binningSupp>0) {
			int n = 0;
			String[] choice = new String[Nbinning+1];
			choice[n++] = "x1";
			if ((binningSupp & IS_BINNING_2X) >0) choice[n++] = "x2";
			if ((binningSupp & IS_BINNING_3X) >0) choice[n++] = "x3";
			if ((binningSupp & IS_BINNING_4X) >0) choice[n++] = "x4";
			if ((binningSupp & IS_BINNING_5X) >0) choice[n++] = "x5";
			if ((binningSupp & IS_BINNING_6X) >0) choice[n++] = "x6";
			if ((binningSupp & IS_BINNING_8X) >0) choice[n++] = "x8";
			if ((binningSupp & IS_BINNING_16X) >0) choice[n++] = "x16";
			gd.addChoice("Binning Mode", choice, choice[0]);
		}
		if(subSamplingSupp>0) {
			int n = 0;
			String[] choice = new String[NsubSampling+1];
			choice[n++] = "x1";
			if ((subSamplingSupp & IS_SUBSAMPLING_2X) >0) choice[n++] = "x2";
			if ((subSamplingSupp & IS_SUBSAMPLING_3X) >0) choice[n++] = "x3";
			if ((subSamplingSupp & IS_SUBSAMPLING_4X) >0) choice[n++] = "x4";
			if ((subSamplingSupp & IS_SUBSAMPLING_5X) >0) choice[n++] = "x5";
			if ((subSamplingSupp & IS_SUBSAMPLING_6X) >0) choice[n++] = "x6";
			if ((subSamplingSupp & IS_SUBSAMPLING_8X) >0) choice[n++] = "x8";
			if ((subSamplingSupp & IS_SUBSAMPLING_16X) >0) choice[n++] = "x16";
			// Display(" "+ n +" / "+ subSamplingSupp);
			gd.addChoice("subSampling Mode", choice, choice[0]);
		}
		boolean syncTest = isPresent("listenCOM");
		if (syncTest) {
				gd.addCheckbox("Activate COM Interface", syncSupp);
				gd.addNumericField("COM port", comPort, 0);
		} else syncSupp = false;
			
       // gd.addHelp(IJ.URL+"/docs/menus/process.html#fft-options");

		UIManager.LookAndFeelInfo plaf[] = UIManager.getInstalledLookAndFeels();
		String[] LaF = new String[plaf.length];
		for (int i = 0; i < plaf.length; i++) {
			LaF[i] = plaf[i].getName();
		}
		gd.addChoice("Look and Feel", LaF, LOOKANDFEEL);
		gd.addCheckbox("Debug mode",debug);
	   
		gd.addMessage(sCop);
		gd.showDialog(); 		// The macro terminates if the user clicks "Cancel"
        if (gd.wasCanceled())
			return 0;

		double newcalib = gd.getNextNumber();
		unit = gd.getNextString();
 		if (calib != newcalib) {
			calibChanged = true;
			calib = newcalib;
		}
		
		autoGain = gd.getNextBoolean();
		if (color) autoWB = gd.getNextBoolean();
		expFPS = (int) gd.getNextNumber();
		// b_LUT = gd.getNextBoolean();
		// Color / Mono Mode
		{
			String choice = gd.getNextChoice();
			if (choice.equals("Mono 8 bits")) {
				if (b_LUT)
					setCM = IS_CM_MONO8;
				else  /* */
					setCM = IS_CM_SENSOR_RAW8;				
				bitspixel = 8;
				stCM = "8-bit Black";
			}
			if (choice.equals("Mono 10 bits")) {
				if (b_LUT)
					setCM = IS_CM_MONO10;
				else  /* */
					setCM = IS_CM_SENSOR_RAW10;
				bitspixel = 10;
				stCM = "16-bit Black";
			}
			if (choice.equals("Mono 12 bits")) {
				if (b_LUT)
					setCM = IS_CM_MONO12;
				else  /* */
					setCM = IS_CM_SENSOR_RAW12;
				bitspixel = 12;
				stCM = "16-bit Black";
			}
			if (choice.equals("Mono 16 bits")) {
				if (b_LUT)
					setCM = IS_CM_MONO16;
				else /* */
					setCM = IS_CM_SENSOR_RAW16;
				bitspixel = 16;
				stCM = "16-bit Black";
			}
			if (choice.equals("RGB 8 bits")) {
				setCM = IS_CM_RGBA8_PACKED;
				bitspixel = 32;
				stCM = "RGB Black";
			}
		}

		if(binningSupp>0) {
			String choice = gd.getNextChoice();
			if (choice.equals("x16")) {
				setBinning = IS_BINNING_16X;
				setDiv = 16;
			}
			if (choice.equals("x8")) {
				setBinning = IS_BINNING_8X;
				setDiv = 8;
			}
			if (choice.equals("x6")) {
				setBinning = IS_BINNING_6X;
				setDiv = 6;
			}
			if (choice.equals("x5")) {
				setBinning = IS_BINNING_5X;
				setDiv = 5;
			}
			if (choice.equals("x4")) {
				Display("INFO - Choice Binning x4");
				setBinning = IS_BINNING_4X;
				setDiv = 4;
			}
			if (choice.equals("x3")) {
				setBinning = IS_BINNING_3X;
				setDiv = 3;
			}
			if (choice.equals("x2")) {
				setBinning = IS_BINNING_2X;
				setDiv = 2;
			}
		}
		if(subSamplingSupp>0) { //
			String choice = gd.getNextChoice();
			if (choice.equals("x16")) {
				setsubSampling = IS_SUBSAMPLING_16X;
				setDiv *= 16;
			}
			if (choice.equals("x8")) {
				setsubSampling = IS_SUBSAMPLING_8X;
				setDiv *= 8;
			}
			if (choice.equals("x6")) {
				setsubSampling = IS_SUBSAMPLING_6X;
				setDiv *= 6;
			}
			if (choice.equals("x5")) {
				setsubSampling = IS_SUBSAMPLING_5X;
				setDiv *= 5;
			}
			if (choice.equals("x4")) {
				Display("INFO - Choice Binning x4");
				setsubSampling = IS_SUBSAMPLING_4X;
				setDiv *= 4;
			}
			if (choice.equals("x3")) {
				setsubSampling = IS_SUBSAMPLING_3X;
				setDiv *= 3;
			}
			if (choice.equals("x2")) {
				setsubSampling = IS_SUBSAMPLING_2X;
				setDiv *= 2;
			}
		}
		if (syncTest) {
			syncSupp = gd.getNextBoolean();
			comPort = (int) gd.getNextNumber();
		}

		LOOKANDFEEL = gd.getNextChoice();
		debug = gd.getNextBoolean();
		return 1;
    }

	public static int getInt(byte[] arr, int off) {
		return arr[off+3]<<24 & 0xFF000000 | arr[off+2]<<16 & 0xFF0000 | arr[off+1]<<8 &0xFF00 | arr[off]&0xFF;
	}
	
	public static int getShort(byte[] arr, int off) {
		return arr[off]<<8 &0xFF00 | arr[off+1]&0xFF;
	}
	
	void InttoByteArray(byte[] Bytes, int offset, int value) {
        Bytes[offset+3] = (byte)(value >> 24);
        Bytes[offset+2] = (byte)(value >> 16);
        Bytes[offset+1] = (byte)(value >> 8);
        Bytes[offset+0] = (byte)value;
	}
	
	CAMLIST GetCameraList(int NumCam) {
		CAMLIST cl = new CAMLIST();
		int sizeCAMINFO = 112;
		byte[] camlist = new byte[4 + sizeCAMINFO*NumCam]; // sizeof = sizeCAMINFO
		camlist[0] = (byte) NumCam;
		int ret = ueye.is_GetCameraList(camlist);
		if (ret != IS_SUCCESS) {
			Display("ERROR - is_GetCameraList");
			return null;	
		} else {
			if (NumCam != getInt(camlist, 0))
				Display("Warning - Numcam doesn't match !!!"); 
			for(int i=0; i<NumCam; i++) {
				int camid = getInt(camlist, i*sizeCAMINFO + 4);
				if (debug) Display("\tcamID :" + camid);
				int devid = getInt(camlist, i*sizeCAMINFO + 8);
				if (debug)  Display("\tdevID :" + devid);
				int sensorid = getInt(camlist, i*sizeCAMINFO + 12);
				if (debug)  Display("\tsensorID :" + sensorid);
				int inUse = getInt(camlist, i*sizeCAMINFO + 16);
				if (debug)  Display("\tinUse :" + inUse);
				try {
					String serial = new String(Arrays.copyOfRange(camlist, i*sizeCAMINFO + 20, i*sizeCAMINFO + 35), "utf8");
					if (debug) Display("\tSerNo :" + serial);
					String model = new String(Arrays.copyOfRange(camlist, i*sizeCAMINFO + 36, i*sizeCAMINFO + 51), "utf8");
					if (debug) Display("\tModel :" + model);
					// choice0[i] = model + serial + (inUse==1?"in use":"ready");

					cl.add(camid, devid, sensorid, (inUse==1?true:false), serial, model);
				} catch (UnsupportedEncodingException e) {
					// choice0[i] = IJ.d2s(i+1,0);
					e.printStackTrace();
				}
			}
		}
		return cl;
	}
	
	boolean Init() {
		boolean error = false;
		try {
			ueye = (UEYE)Native.loadLibrary("ueye_api_64", UEYE.class); //libueye_api.so
		} catch (Throwable t) {
			error = true;
		}

		if (error) {
			error = false;
			try {
				ueye = (UEYE)Native.loadLibrary("ueye_api", UEYE.class); //libueye_api.so
			} catch (Throwable t) {
				error = true;
			}
		}
		if (error) {
			Display("Library libueye_api not found");
			return false;
		}

		enable.setValue(1);
		disable.setValue(0);

		int ret;
		int ver = ueye.is_GetDLLVersion();
		boolean bDllVersion = false;
		int nDllMajor = ver >> 24;
		int nDllMinor = ver >> 16 & 0xff;
		int build = ver & 0xffff;
		if (nDllMajor > DLL_VER_MAJOR)
			bDllVersion = true;
		else if (nDllMajor == DLL_VER_MAJOR)
		{
			if (nDllMinor >= DLL_VER_MINOR)
				bDllVersion = true;
		}
		st= "--- START ---";
		if (console)
				Display(st);
			else IJ.log(st);

		Display("libueye_API version "+nDllMajor+"."+nDllMinor+"."+build);

		if (!bDllVersion) {
			Display("WARNING : this version doesn't work with libueye_api < "+ DLL_VER_MAJOR+"."+DLL_VER_MINOR+"!");
			return false;
		}

		IntByReference pNumCam = new IntByReference();
		ret = ueye.is_GetNumberOfCameras(pNumCam);
		if (IS_SUCCESS == ret) {
			NumCam = pNumCam.getValue();
			if (NumCam > 0)
				st = "Found "+NumCam+" IDS cam...";
			else {
				st ="No IDS cam found";
				bDllVersion = false;
			}
			Display(st);
		} else {
			pNumCam.setValue(0);
			st = "Error on Cam detection";
			Display(st);
			bDllVersion = false;
		}
		
		int IDcam = 0;
		pHIDS = new IntByReference();
		if (bDllVersion && NumCam > (ListCam?1:0)) {  // Camera Selection
			GenericDialog gd = new GenericDialog(sVer);
			gd.setInsets(0, 75, 0) ;
			gd.addMessage("[Model]              [serial number]        [state]");
			String[] choice0 = new String[NumCam];
			CAMLIST cl = GetCameraList(NumCam);
			for(int i=0; i<NumCam; i++) {
				// choice0[i] = IJ.d2s(i+1,0);
				choice0[i] = cl.getString(i);
			}
			gd.addChoice("ID cam", choice0, choice0[0]);
			gd.addCheckbox("Do not show if only one camera exist", ListCam);
			gd.addMessage(sCop);
			gd.showDialog();
			if (gd.wasCanceled())
				return false;
			IDcam = gd.getNextChoiceIndex(); 
			if (debug)  Display("DevID   : " + cl.getDevID(IDcam));
			if (debug)  Display("Call ID : " + (cl.getDevID(IDcam) | IS_USE_DEVICE_ID));
			pHIDS.setValue(cl.getDevID(IDcam) | IS_USE_DEVICE_ID); // opened by devID
			ListCam = gd.getNextBoolean();
		}
		if (NumCam < 1)	return false;		

		if (bDllVersion) {
			ret = ueye.is_InitCamera(pHIDS, Pointer.NULL);
			if (IS_SUCCESS != ret) {
				st = "Error initializing IDS cam!";
				bDllVersion = false;
			} else st = "IDS Cam initialisation successfull!";
			Display(st);
		}
		
	// Info SENSOR
		if (bDllVersion) {
			UEYE.SENSORINFO.ByReference sensinfo = new UEYE.SENSORINFO.ByReference();
			ret = ueye.is_GetSensorInfo(pHIDS.getValue(), sensinfo);
			if (ret != IS_SUCCESS) {
				Display("ERROR - IS_GetSensor");
			} else {
				Display("INFO - SensorID : "+ sensinfo.SensorID);
				try {
					ModelName = new String(sensinfo.strSensorName, "UTF8");
					Display("   Model :" + ModelName);
				}
				catch (UnsupportedEncodingException e) {
					e.printStackTrace();
				}
				if (debug) Display("   ColorMode :" + sensinfo.nColorMode);
				color = (sensinfo.nColorMode>1?true:false);
				if(color) Display("   Color Model");
				else Display("   Monochrome Model");
				Display("   Max Width  : "+sensinfo.nMaxWidth);
				MaxWidth = sensinfo.nMaxWidth;
				Display("   Max Height : "+sensinfo.nMaxHeight);
				MaxHeight = sensinfo.nMaxHeight;
				Display("   Pixel size : "+(sensinfo.wPixelSize/100.0)+"um");
				if (sensinfo.bGlobShutter) Display("INFO - Global Shutter supported");
				else Display("INFO - Global Shutter not supported");
			}
		}
		
		if (bDllVersion) {
			ret = ueye.is_GetBusSpeed(pHIDS.getValue());
			switch (ret) {
				case 1 : st = "ERROR - Connected to a USB1 controller!"; bDllVersion = false; break;
				case 2 : st = "ERROR - Connected to a USB1 controller!"; bDllVersion = false; break;
				case 4 : st = "INFO - Connected to a USB2 controller"; usb=2; break;
				case 8 : st = "INFO - Connected to a USB3 controller"; usb=3; break;
				default : st = "Error - GetBusSpeed!";
			}
			Display(st);
		}
		if (!bDllVersion) return false;
		
									// IS_STANDBY_SUPPORTED
		// long ulvalue=0;
		// ulvalue = ueye.is_CameraStatus(pHIDS.getValue(), 25, ulvalue);
		// Display("Stand by mode : "+(ulvalue==0?"No":"Yes"));
		IntByReference pAOIsupp = new IntByReference();
		ret = ueye.is_ImageFormat(pHIDS.getValue(), 4, pAOIsupp.getPointer(), 4); // IMGFRMT_CMD_GET_ARBITRARY_AOI_SUPPORTED
		if (IS_SUCCESS != ret) {
			st = "ERROR - ISImageFormat!";
		} else {
			AOIsupp = (pAOIsupp.getValue() != 0);
			if (AOIsupp)
				st = "INFO - AOI supported";
			else st = "INFO - AOI not supported";
		}
		Display(st);
		
		if (AOIsupp) {
			IntByReference pmultiAOIsupp = new IntByReference();
			{
				ret = ueye.is_AOI(pHIDS.getValue(), 0x0400 | 0x0003, pmultiAOIsupp.getPointer(), 4); // IS_AOI_MULTI_GET_AOI | IS_AOI_MULTI_MODE_GET_MAX_NUMBER
				if (IS_SUCCESS != ret) {
					Display( "ERROR - Multi_AOI !");
				} else {
					if (pmultiAOIsupp.getValue()>1) {
						Display("INFO - Multi_AOI supported");
						Display("Multi_AOI : Max nb = "  + pmultiAOIsupp.getValue());
					}
				}
			}
		}
		
		binningSupp = ueye.is_SetBinning(pHIDS.getValue(), IS_GET_SUPPORTED_BINNING);
		if (binningSupp == 0) st = "No binning mode supported";
		else {
			st = "INFO - binning Mode ";//x2, x4 supported...";
			if ((binningSupp & IS_BINNING_2X) > 0)  { Nbinning++; st +="x2 ";}
			if ((binningSupp & IS_BINNING_3X) > 0)  { Nbinning++; st +="x3 ";}
			if ((binningSupp & IS_BINNING_4X) > 0)  { Nbinning++; st +="x4 ";}
			if ((binningSupp & IS_BINNING_5X) > 0)  { Nbinning++; st +="x5 ";}
			if ((binningSupp & IS_BINNING_6X) > 0)  { Nbinning++; st +="x6 ";}
			if ((binningSupp & IS_BINNING_8X) > 0)  { Nbinning++; st +="x8 ";}
			if ((binningSupp & IS_BINNING_16X) > 0)  { Nbinning++; st +="x16 ";}
			st += "supported ";
		}
		Display(st);
		
		subSamplingSupp = ueye.is_SetSubSampling(pHIDS.getValue(), IS_GET_SUPPORTED_SUBSAMPLING);
		if (subSamplingSupp == 0) st = "No subSampling mode supported";
		else {
			st = "INFO - subSampling Mode ";//x2, x4 supported...";
			if ((subSamplingSupp & IS_SUBSAMPLING_2X) > 0)  { NsubSampling++; st +="x2 ";}
			if ((subSamplingSupp & IS_SUBSAMPLING_3X) > 0)  { NsubSampling++; st +="x3 ";}
			if ((subSamplingSupp & IS_SUBSAMPLING_4X) > 0)  { NsubSampling++; st +="x4 ";}
			if ((subSamplingSupp & IS_SUBSAMPLING_5X) > 0)  { NsubSampling++; st +="x5 ";}
			if ((subSamplingSupp & IS_SUBSAMPLING_6X) > 0)  { NsubSampling++; st +="x6 ";}
			if ((subSamplingSupp & IS_SUBSAMPLING_8X) > 0)  { NsubSampling++; st +="x8 ";}
			if ((subSamplingSupp & IS_SUBSAMPLING_16X) > 0)  { NsubSampling++; st +="x16 ";}
			st += "supported ";
		}
		Display(st);

		if (1 == ueye.is_SetGainBoost(pHIDS.getValue(),2)) //IS_GET_SUPPORTED_GAINBOOST
		{
			boostGainSupp = true;
			Display("INFO - Gain Boost supported");
		} else Display("INFO - Gain Boost not supported");
		return true;
	}
	
	boolean setAutoGain(boolean auto, int value) {
		int ret;
		DoubleByReference pval = new DoubleByReference();
		ret = ueye.is_SetAutoParameter(pHIDS.getValue(), IS_GET_ENABLE_AUTO_GAIN, pval, disable);
			// Display("INFO - "+ ret + " - " + pval.getValue());
		if (auto) {
			if (pval.getValue() == 0) {
				ret = ueye.is_SetAutoParameter(pHIDS.getValue(), IS_SET_ENABLE_AUTO_GAIN, enable, disable);
				ueye.is_SetAutoParameter (pHIDS.getValue(), IS_SET_ENABLE_AUTO_SENSOR_GAIN, enable, disable);
				if (ret != IS_SUCCESS) return false;
				else return true;
			}
		} else {
			if (pval.getValue() == 1) {
				ret = ueye.is_SetAutoParameter(pHIDS.getValue(), IS_SET_ENABLE_AUTO_GAIN, disable, disable);
				ueye.is_SetAutoParameter (pHIDS.getValue(), IS_SET_ENABLE_AUTO_SENSOR_GAIN, disable, disable);
				if (ret != IS_SUCCESS) return false;
				ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8004, value); //IS_SET_MASTER_GAIN_FACTOR
				return true;
			} else ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8004, value); //IS_SET_MASTER_GAIN_FACTOR
		}
		return true;
	}

	boolean setAutoShutter(boolean auto, int value) {
		int ret;
		if (auto) {
			ret = ueye.is_SetAutoParameter(pHIDS.getValue(), IS_SET_ENABLE_AUTO_SHUTTER, enable, disable);
			ueye.is_SetAutoParameter(pHIDS.getValue(), IS_SET_ENABLE_AUTO_SENSOR_SHUTTER, enable, disable);
			if (ret != IS_SUCCESS) return false;
			else return true;
		} else {
			ret = ueye.is_SetAutoParameter(pHIDS.getValue(), IS_SET_ENABLE_AUTO_SHUTTER, disable, disable);
			ueye.is_SetAutoParameter (pHIDS.getValue(), IS_SET_ENABLE_AUTO_SHUTTER, disable, disable);
			if (ret != IS_SUCCESS) return false;
			DoubleByReference exp = new DoubleByReference();
				// ueye.is_Exposure(pHIDS.getValue(), 7, exp.getPointer(), 8);
				// Display("Exposure time : " + exp.getValue());
			exp.setValue((1.0*value)/1000.0);
			ueye.is_Exposure(pHIDS.getValue(), 12, exp.getPointer(), 8);		//IS_EXPOSURE_CMD_SET_EXPOSURE
			return true;
		}
	}

	int set_AOI_Rect(int nCommand, UEYE.RECT rect) {
		Pointer ptr = new Memory(4 * 4);
		ptr.setInt(0 * 4, rect.x);
		ptr.setInt(1 * 4, rect.y);
		ptr.setInt(2 * 4, rect.cx);
		ptr.setInt(3 * 4, rect.cy);
		int ret = ueye.is_AOI(pHIDS.getValue(), nCommand, ptr, 4*4);
		return ret;
	}

	int set_AOI_Size(int nCommand, UEYE.IS_SIZE2D coord) {
		Pointer ptr = new Memory(2 * 4);
		ptr.setInt(0 * 4, coord.Width);
		ptr.setInt(1 * 4, coord.Height);
		int ret = ueye.is_AOI(pHIDS.getValue(), nCommand, ptr, 2*4);
		return ret;
	}

	int get_AOI_Size(int nCommand, UEYE.IS_SIZE2D coord) {
		Pointer ptr = new Memory(2 * 4);
		int ret = ueye.is_AOI(pHIDS.getValue(), nCommand, ptr, 2*4);
		coord.Width = ptr.getInt(0 * 4);
		coord.Height = ptr.getInt(1 * 4);
		return ret;
	}

	private static long getMemoryFree(){
		return Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
		//return Runtime.getRuntime().freeMemory();
	}
	
	private void startRecording(int keyCode) {
		ImagePlus nimp;
		Roi roi = imp.getRoi();
		if (roi != null && roi.isArea()) 
			if (AOI_rect.x != 0 || AOI_rect.y != 0) {
				imp.deleteRoi();
				roi = null;
			}
		nimp = imp.duplicate();
		ImageProcessor nip = nimp.getProcessor();
		nip.setRoi(AOI_rect.x, AOI_rect.y, AOI_rect.cx, AOI_rect.cy);
		nimp.setProcessor(null, nip.crop());
		switch (keyCode) {
			case 77 :  //Multi-snap
/*				nimp.setTitle("Multi-snap");
				if(nImage==0) {
					nimp.copyScale(imp);
					ist = nimp.createEmptyStack();
					// Calibration cal = nimp.getCalibration();
					ist.addSlice(nip.crop());
					nimp.show();
				} else {
					ist.addSlice(nip.crop());
					// imp.setSlice(ist.getSize());
					nimp.setStack(ist);
					// nimp.updateImage();
					// nimp.updateAndRepaintWindow();
				}
				nImage++;
				break;  /* */
/*
				if (IJ.isOpen("Multi-snap")) {
					nimp.setTitle("IDS_dup"+nImage);
				} else {
					nImage = 0;
					nimp.setTitle("Multi-snap");
				}
*/				
				if (nImage == 0) {
					nimp.setTitle("Multi-snap");
				} else nimp.setTitle("IDS_dup"+nImage);
				nimp.copyScale(imp);
				nimp.show();
				if (nImage > 0) {
					IJ.run("Concatenate...", "  title=[Multi-snap] image1=Multi-snap image2=IDS_dup"+nImage);
				}
				nImage++;
				break;/* */
			case 83 : // Snap
				nimp.setTitle("IDS_dup");
				nimp.copyScale(imp);
				nimp.show();			
				break;	
//TO COMMENT
			case 86: // V  // Recording with all memory
			case 82: // R  // Recording with frame/time number
				if (!bsav) {
					long FreeMem = getMemoryFree();
					long reserve = 100 * 1000000; //X MB de marge
					IJ.log("Size of free memory: " + (FreeMem/1000000) + " MB"); 
					MaxImage = (FreeMem-reserve)/(AOI_rect.cx*AOI_rect.cy*uBytesPerPixel);
					if (roi != null && roi.isArea()) {
						if (AOI_rect.x != 0 || AOI_rect.y != 0) {
						} else {
							Rectangle rect = roi.getBounds();
							Display("INFO - Selection : "+rect.height+" - " + rect.width);
							MaxImage = (FreeMem-reserve)/(rect.height*rect.width*uBytesPerPixel);
						}
					}
					if (keyCode == 82) {

						final JDialog dialog2 = new JDialog();
						JPanel centerPanel = new JPanel(new BorderLayout());
						
						JPanel sliderPanel = new JPanel();
						sliderPanel.setLayout(new GridLayout(0, 2));
						
						lb_image = new JTextField(4);
						sl_image = addSlider(sliderPanel, "Images (nb) : ", lb_image, 1, (int)MaxImage, (int)MaxImage);
						lb_time = new JTextField(4);
						sl_time = addSlider(sliderPanel, "time (in sec) : ", lb_time, 1, (int)(MaxImage/dblFPS.getValue()), (int)(MaxImage/dblFPS.getValue()));
						
						centerPanel.add(sliderPanel, BorderLayout.CENTER);

						JPanel buttonPane = new JPanel();
						buttonPane.setLayout(new FlowLayout(FlowLayout.CENTER));
						JButton okButton = new JButton("Do it");
						okButton.addActionListener(new ActionListener() {
							public void actionPerformed(ActionEvent arg0) {
								MaxImage = sl_image.getValue();
								dialog2.dispose();
							}
						});
						buttonPane.add(okButton);
						dialog2.getRootPane().setDefaultButton(okButton);
						JButton cancelButton = new JButton("Cancel");
						cancelButton.addActionListener(new ActionListener() {
							public void actionPerformed(ActionEvent arg0) {
								dialog2.dispose();
							}
						});
						buttonPane.add(cancelButton);						
						
						centerPanel.add(buttonPane, BorderLayout.SOUTH);						
						dialog2.add(centerPanel, BorderLayout.CENTER);
						
						JStatusBar statusBar = new JStatusBar();
						//sb_left = new JLabel("Acquiring at " + getSpeed());
						statusBar.setLeftComponent(new JLabel(sCop));
						dialog2.add(statusBar, BorderLayout.SOUTH);
						
						MaxImage = 0;
						dialog2.pack();
						
						Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
						dialog2.setLocation((screen.width/2-400), (screen.height-200)/2);
						dialog2.setSize(400,200);
						dialog2.setTitle("Recording");
						dialog2.setModal(true);
						
						dialog2.setVisible(true);
						
					} 
					if (MaxImage == 0) 		break;
					IJ.log("Nb of image to save: " + (MaxImage)); 
					IJ.log("duration of recording: " + IJ.d2s((MaxImage/dblFPS.getValue()),2) + " sec");
					if (MaxImage>0) {
						end = false;
						IJ.log("Recording video in memory ..."); 
						ist = nimp.createEmptyStack();
						sb_left.setText("Recording " + MaxImage + " images");
						
						bsav = true;
						StartTime = System.nanoTime()/1000;
					} else {
						IJ.log("Not enougth memory ... disabling recording."); 
					}
				} else { 
					// sync : switch off the LED				
					if (cbi_rts == 3) 	sync.sendRTS(true);
					bsav = false;
					long EndTime = System.nanoTime()/1000; //us
					sb_left.setText("Acquiring at " + getSpeed());
					nimp.setStack(ist);
					nimp.copyScale(imp);
					// cal.frameInterval = 1000/dblFPS.getValue();
					nimp.setTitle("video"+nVideo);
					nVideo++;
					nimp.show(); 
					// long laps = (EndTime-StartTime); 
					// IJ.log("Time laps: "+ IJ.d2s((laps/1000000.0),3) + " sec");
					
					long first = Long.parseLong(nimp.getStack().getSliceLabel(1));
					long last = Long.parseLong(nimp.getStack().getSliceLabel(nimp.getStackSize()));
					long laps = last - first;
					
					IJ.log("Stop recording, opening frames...");
					IJ.log("Frame interval: " + IJ.d2s(1000/dblFPS.getValue(),2) + " ms");
					IJ.log("Time laps: "+ IJ.d2s((laps/1000000.0),3) + " sec");
					double fic = 0;
					if (nimp.getStackSize()>1)
						fic = (0.001*laps)/(nimp.getStackSize()-1); // FG A voir !!!!!!
					IJ.log("Real Video Frequency Acquisition: "+ IJ.d2s((1000.0/fic),1) + " Hz");
					IJ.log("Corrected Frame interval: " + IJ.d2s(fic,2) + " ms");
					Calibration cal = nimp.getCalibration();
					cal.setTimeUnit("msec");
					if (dblFPS.getValue()!=0)
						cal.frameInterval = fic;
					else cal.frameInterval = 0;
					
					MaxImage = -1;
				}
				break;
		}
	}

	public void run(String s) {
		loadDefaultValues();
		Active = Init();
		if (!Active)
			return;
		if (showInitDialog()==0)  {
			Close();
			return;
		}
		initLookAndFeel();
		JFrame.setDefaultLookAndFeelDecorated(true);
		int ret;
		ret = ueye.is_SetDisplayMode(pHIDS.getValue(), 0x801); //1=IS_SET_DM_DIB
		if (IS_SUCCESS != ret) {
			st = "Error initializing DisplayMode!";
		} else st = "Set DisplayMode (DIB) successfull!";
		Display(st);
/*
		IntByReference pnCol = new IntByReference();
		IntByReference pnColMode = new IntByReference();
		ret = ueye.is_GetColorDepth(pHIDS.getValue(), pnCol, pnColMode);
		if (IS_SUCCESS != ret) {
			Display("ERROR - IS_GetColor!");
		} else {
			Display("SUCCES - nCol = " + pnCol.getValue());
			Display("SUCCES - nColMode = "+pnColMode.getValue());
		}
*/
/*
		IntByReference pInit = new IntByReference();
		pInit.setValue(0);			// IS_CONFIG_INITIAL_PARAMETERSET_NONE;
		ret = ueye.is_Configuration(10, pInit.getPointer(), 4);
		if (ret != IS_SUCCESS) Display("ERROR - IS_Config");
		else Display("SUCCESS - pInit : " + pInit.getValue());

		// do this only if there is no 'initial parameter set' installed.
		// if an 'initial parameter set' is installed we must not overwrite this setup!
		if (pInit.getValue() == 0) { 				// IS_CONFIG_INITIAL_PARAMETERSET_NONE
			ret = ueye.is_ResetToDefault(pHIDS.getValue());
			if (ret != IS_SUCCESS) Display("ERROR - IS_Reset");
			else Display("SUCCESS - Reset to default");
		}

		ret = ueye.is_ClearSequence(pHIDS.getValue());
		if (ret != IS_SUCCESS) Display("ERROR - IS_clearSeq");
/**/
		// if ((binningSupp & 0x15) > 0)
		{
			ueye.is_SetBinning(pHIDS.getValue(), setBinning);
			binningMode = ueye.is_SetBinning(pHIDS.getValue(), IS_GET_BINNING);
			Display("INFO - Binning Set : " + binningMode);
			if (binningMode == setBinning) {
				vDiv = hDiv = setDiv;
			} else Display("ERROR - Binning Mode " + binningMode);
			
			ueye.is_SetSubSampling(pHIDS.getValue(), setsubSampling);
			subSamplingMode = ueye.is_SetSubSampling(pHIDS.getValue(), IS_GET_SUBSAMPLING);
			Display("INFO - subSampling Set : " + subSamplingMode);
			if (subSamplingMode == setsubSampling) {
				vDiv = hDiv = setDiv;
			} else Display("ERROR - subSampling Mode " + subSamplingMode);
		}

		//IS_CM_BGRA8_PACKED //IS_CM_RGBA8_PACKED
		ret = ueye.is_SetColorMode(pHIDS.getValue(), setCM); //IS_CM_MONO8
		if (ret != IS_SUCCESS) {
			st="ERROR (BACK TO MONO_8)";
			setCM = IS_CM_MONO8;
			bitspixel = 8;
			ueye.is_SetColorMode(pHIDS.getValue(), setCM); //IS_CM_MONO8
			stCM = "8-bit Black";
		}
		else st ="SUCCES";
		Display(st + " - IS_SetColorMode");

		ImgSize = new UEYE.IS_SIZE2D();
		ImgSize.Width = MaxWidth / hDiv;
		ImgSize.Height = MaxHeight / vDiv;
		uBytesPerPixel = (bitspixel+7)/8;
		uImageSize = ImgSize.Width * ImgSize.Height;// * uBytesPerPixel;

		int decalDisplay = 0;
		imp = IJ.createImage("IDS Cam", stCM, ImgSize.Width, ImgSize.Height + decalDisplay, 1);
		ip = imp.getProcessor();
		ist = imp.createEmptyStack();
		Calibration cal = imp.getCalibration();
		// cal.setUnit("micron");
		cal.setUnit(unit);
		cal.pixelWidth = calib*setDiv;
		cal.pixelHeight = calib*setDiv;
		switch(uBytesPerPixel) {
			case 4 : pix32 = (int[]) ip.getPixels(); break;
			case 2 : pix16 = (short[]) ip.getPixels();break;
			case 1 : pix8 = (byte[]) ip.getPixels();break;
		}
		ppcImgMem = new PointerByReference();
		pid = new IntByReference();
		ret = ueye.is_AllocImageMem(pHIDS.getValue(), ImgSize.Width, ImgSize.Height, bitspixel, ppcImgMem, pid);

		Display("INFO - BPP : " + bitspixel);
		Display("INFO - Memory size : " + uImageSize);
		if (ret != IS_SUCCESS) Display("ERROR - IS_allocMem");
		else {
			Display("SUCCESS - pid : " + pid.getValue());
			Display("SUCCESS - ppcImgMem : " + ppcImgMem.getValue());
		}

		ret = ueye.is_SetImageMem(pHIDS.getValue(), ppcImgMem.getValue(), pid.getValue());
		if (ret != IS_SUCCESS) st="ERROR";
		else st ="SUCCES";
		Display(st + " - IS_SetImageMem");

		Display("INFO - Width : " + ImgSize.Width);
		Display("INFO - Height : " + ImgSize.Height);
		Display("Structure Size : " + ImgSize.size());

		ret = set_AOI_Size(5, ImgSize); // IS_AOI_IMAGE_SET_SIZE
//		ret = ueye.is_SetImageSize(pHIDS.getValue(), ImgSize.Width, ImgSize.Height);
		if (ret != IS_SUCCESS) st="ERROR ("+ret+")";
		else st ="SUCCES";
		Display(st + " - IS_AOI"); /**/

		{	//Params auto
			Pointer range = new Memory(3 * 4);
			ret = ueye.is_PixelClock(pHIDS.getValue(), 3, range, 12); //IS_PIXELCLOCK_CMD_GET_RANGE
			if (ret != IS_SUCCESS) st="ERROR";
			else st ="SUCCES";
			Display(st + " - IS_PixelClock");
			if (ret == IS_SUCCESS) {
				st="INFO - "+range.getInt(0 * 4)+" "+range.getInt(1 * 4)+" "+range.getInt(2 * 4)+" ";
				Display(st);
			}

			maxClock = range.getInt(1 * 4);
			minClock = range.getInt(0 * 4);
			incClock = range.getInt(2 * 4);
			
			nbInc = 0;
			if (incClock != 0) {
				nbInc = (maxClock - minClock) / incClock;
			} else {
				IntByReference inc = new IntByReference();
				ueye.is_PixelClock(pHIDS.getValue(), 1, inc.getPointer(), 4); //IS_PIXELCLOCK_CMD_GET_NUMBER
				nbInc = inc.getValue();
			}
			
			if (incClock != 0) {
				IntByReference newClock = new IntByReference();
				newClock.setValue( minClock + incClock*nbInc/4 );
				ret = ueye.is_PixelClock(pHIDS.getValue(), 6, newClock.getPointer(), 4); //IS_PIXELCLOCK_CMD_SET
				if (ret != IS_SUCCESS) st="ERROR";
				else st ="SUCCES";
				Display(st + " - IS_SetpixelClock");
			} else {
				arrayClock = new Memory(nbInc*4);
				ret = ueye.is_PixelClock(pHIDS.getValue(), 2, arrayClock, nbInc*4); //IS_PIXELCLOCK_CMD_GET_LIST
				if (ret != IS_SUCCESS) st="ERROR";
				else st ="SUCCES";
				Display(st + " - IS_SetpixelClock - set Array Clock ");
			}
			DoubleByReference enable = new DoubleByReference();
			enable.setValue(1);
			DoubleByReference disable = new DoubleByReference();
			disable.setValue(0);
			if (setAutoGain(autoGain, gain))
				st ="SUCCES";
			else st="ERROR";
			Display(st + " - IS_SetAuto Gain On");

			if(autoWB) {
				ret = ueye.is_SetAutoParameter(pHIDS.getValue(), IS_SET_ENABLE_AUTO_WHITEBALANCE, enable, disable);
				if (ret != IS_SUCCESS) st="ERROR";
				else st ="SUCCES";
				Display(st + " - IS_SetAuto WB On");
				ret = ueye.is_SetAutoParameter (pHIDS.getValue(), IS_SET_ENABLE_AUTO_SENSOR_WHITEBALANCE, enable, disable);
			}

			ret = ueye.is_SetAutoParameter(pHIDS.getValue(), IS_SET_ENABLE_AUTO_FRAMERATE, disable, disable);
			if (ret != IS_SUCCESS) st="ERROR";
			else st ="SUCCES";
			Display(st + " - IS_SetAuto FrameRate Off");

			if (autoShutter) {
				if (setAutoShutter(autoShutter, 0))
					st ="SUCCES";
				else st="ERROR";
				Display(st + " - IS_SetAuto Shutter On");
			}
		}

		ret = ueye.is_CaptureVideo(pHIDS.getValue(), 1);	// Continue , 1=IS_WAIT  0=IS_DONT_WAIT
		if (ret != IS_SUCCESS) Display("ERROR - IS_Capture"); /**/

		try {	// pour lui laisser le temp d'obtenir le bon fps
				Thread.sleep(1000);
			} catch(InterruptedException ex) {
				Thread.currentThread().interrupt();
			} /* */

		ret = ueye.is_GetFramesPerSecond (pHIDS.getValue(), dblFPS);
		if (ret != IS_SUCCESS) Display("ERROR - IS_getFR");
		else Display("SUCCESS - FrameRate : "+ dblFPS.getValue());

		pcImgMem = ppcImgMem.getValue();
		imp.show();
		int fr = 0;

		if (AOIsupp) {
			AOI_pos_min = new UEYE.IS_SIZE2D();
			AOI_pos_inc = new UEYE.IS_SIZE2D();
			AOI_size_inc = new UEYE.IS_SIZE2D();
			AOI_size_min = new UEYE.IS_SIZE2D();
			
			ret = get_AOI_Size(0x0007, AOI_pos_min);		// IS_AOI_IMAGE_GET_POS_MIN
			if (ret != IS_SUCCESS) Display("ERROR - IS_AOI");
			else Display("INFO AOI_pos_min : ("+AOI_pos_min.Width+","+AOI_pos_min.Height+")");
			ret = get_AOI_Size(0x0008, AOI_size_min);		// IS_AOI_IMAGE_GET_SIZE_MIN
			if (ret != IS_SUCCESS) Display("ERROR - IS_AOI");
			else Display("INFO AOI_size_min : ("+AOI_size_min.Width+","+AOI_size_min.Height+")");
			
			ret = get_AOI_Size(0x0011, AOI_pos_inc);		// IS_AOI_IMAGE_GET_POS_INC
			if (ret != IS_SUCCESS) Display("ERROR - IS_AOI");
			else Display("INFO AOI_pos_inc : ("+AOI_pos_inc.Width+","+AOI_pos_inc.Height+")");
			ret = get_AOI_Size(0x0012, AOI_size_inc);		// IS_AOI_IMAGE_GET_SIZE_INC
			if (ret != IS_SUCCESS) Display("ERROR - IS_AOI");
			else Display("INFO AOI_size_inc : ("+AOI_size_inc.Width+","+AOI_size_inc.Height+")");
		}
		AOI_rect = new UEYE.RECT.ByReference();
		AOI_rect.x = 0;
		AOI_rect.y = 0;
		AOI_rect.cx = ImgSize.Width;
		AOI_rect.cy = ImgSize.Height; /* */
		
		DoubleByReference pFPS = new DoubleByReference();
		ret = ueye.is_SetFrameRate(pHIDS.getValue(), (double) expFPS, pFPS);
		Display("INFO - wanted FrameRate : "+ expFPS + "("+ pFPS.getValue()+")"); /**/
		boolean error=false;
		
		showControlDialog();
		int rdFPS = 0;

		if (bitspixel==10)
			ip.setMinAndMax(1, 1023);
		if (bitspixel==12)
			ip.setMinAndMax(1, 4095);
	
		win = imp.getWindow();
		canvas = win.getCanvas();
		win.removeKeyListener(IJ.getInstance());
		canvas.removeKeyListener(IJ.getInstance());
		
		win.addKeyListener(this);
		canvas.addKeyListener(this);
		ImagePlus.addImageListener(this);

// sync : init
		// listenCOM sync;
		sync = null;
		if (syncSupp) {
			if (debug) Display( "COM interface (GetSync.jar) found");
			sync = new listenCOM();
			sync.setPort(comPort);
			sync.setPriority(Thread.MAX_PRIORITY);
			// sync.setPriority(Thread.NORM_PRIORITY - 1);
			sync.start();
			
			if (!sync.isStarted(3000)) {
				Display("Warning : Cannot initialize COM port");
				IJ.showMessage("Warning", "Cannot initialize COM port!!!");
				sync.interrupt();
				sync = null;
				syncSupp = false;
			}
		}
// sync : switch off the LED
		if (syncSupp) 	{ 
			sync.sendRTS(true); 
			sync.sendDTR(false); 
		}
		
		long synchroWait = 0;
		long synchroWaitProto= 0;
		long synchroStart = 0;
		long timeStamp;
		boolean cb_acqProto = false;
		
		ImagePlus dimp;
		hEvent = new HANDLE();
		if (isWindows()) {
			hEvent = Kernel32.INSTANCE.CreateEvent(null, false, false, null);
			ueye.is_InitEvent(pHIDS.getValue(), hEvent, 0);	//0 =  IS_FRAME
		}
		ueye.is_EnableEvent(pHIDS.getValue(), 0);
		String meta="";
		IntByReference LED = new IntByReference();
		boolean LEDblk = true;
		LED.setValue(2); //IO_LED_ENABLE
		ueye.is_IO(pHIDS.getValue(), 9, LED.getPointer(), 4); // IS_IO_CMD_LED_SET_STATE
		
		while (Active) {
			if (IJ.getInstance() == null) {	if (syncSupp) sync.interrupt(); sync = null; Close(); break;} 
			if (isWindows()) {
				Kernel32.INSTANCE.WaitForSingleObject( hEvent, 2000);
			} else 
				ret = ueye.is_WaitEvent(pHIDS.getValue(), 0, 2000); //0 =  IS_FRAME
			timeStamp = System.nanoTime()/1000 - StartTime;
			if (syncSupp) {
// sync : temporisation LED off
				if (synchroWait>0) {
					synchroWait--;
					if (synchroWait==0) { 
						LED.setValue(2); //IO_LED_ENABLE
						ueye.is_IO(pHIDS.getValue(), 9, LED.getPointer(), 4); // IS_IO_CMD_LED_SET_STATE
					}
				} 

				if (synchroStart>0) {
					synchroStart--;
					if (synchroStart==0) { 
						startRecording(77);
					}
				} 
				
				if (synchroWaitProto>0) {
					synchroWaitProto--;
					if (synchroWaitProto==0) {
						if (cb_acqProto) {
							startRecording(77); 	//86-video 83-snap 77-
							cb_acqProto  = false;  	//false = shutter fermé
							sync.sendDTR(cb_acqProto); 
							synchroWaitProto = (int) (dblFPS.getValue() * (proto_periode - 0.5));			  // freq = 1 Hz !! voir resol timer  => 1s - 0.5s
						} else {
							synchroWaitProto = (int) (dblFPS.getValue() * 0.5);  // delay = 500ms !! voir resol timer
							cb_acqProto = true;		//true = shutter ouvert
							sync.sendDTR(cb_acqProto);  // ouvrir shutter
						}
					}
				}
// sync : switch on the LED at the same frequency of the video
				if (cbi_rts == 1) 	sync.switchRTS();
				
// sync : switch the Camera LED				
				if (cbi_led == 1) { // each image
					// ret = ueye.is_IO(pHIDS.getValue(), 10, Pointer.NULL, 0); // IS_IO_CMD_LED_TOGGLE_STATE 
					// IJ.log(""+ret);	//  (not supported err 155)
					// IJ.log("LED");
					LED.setValue(LEDblk?3:2); //IO_LED_DISABLE
					ueye.is_IO(pHIDS.getValue(), 9, LED.getPointer(), 4); // IS_IO_CMD_LED_SET_STATE
					LEDblk = (LEDblk?false:true);
				}

// sync : mark the video
				// meta="";
				if (sync.isDSR()) { 
					if (cb_sync) 	meta="sync ";
					if (cb_syncbip) 	IJ.beep();
					if (cbi_rts == 2) 	sync.switchRTS();
					if (cbi_led == 2) { // each sync on DSR
						// sync : switch the Camera LED
						if (synchroWait <= 0) {
							LED.setValue(3); //IO_LED_DISABLE
							ueye.is_IO(pHIDS.getValue(), 9, LED.getPointer(), 4); // IS_IO_CMD_LED_SET_STATE
							synchroWait = (int) dblFPS.getValue()/10; // temporisation LED
							synchroWait = (synchroWait<1?1:synchroWait); 
						}
					}
				}
				
// sync : mark the video
				if (sync.isCTS()) { 
					if (cb_top) meta+="top ";
					if (cb_vidAcq) 	{
						// sync : switch on the LED
						startRecording(86); //86-video 83-snap 77-
					}
					if (cb_snap)
						if (delay==0)
							startRecording(77); //86-video 83-snap 77-
						else {
							synchroStart = (int) (dblFPS.getValue() * delay);
							// Display("delay : "+synchroStart);
						}
					if (cb_beep) IJ.beep();
				}
				
// sync : send TTL signal
				if (SPACE) {
					meta+="mark ";
	// if(cb_dtr) {  // A VOIR !!!!!!
		// sync.switchDTR();
	// }
					if ( synchroWaitProto>0) { 	//STOP PROTO
						synchroWaitProto = 0; // bloquer proto
						cb_acqProto  = false;  	// = shutter fermé
						sync.sendDTR(cb_acqProto);  // fermer shutter
					} else if  (cb_proto ) { 	//START PROTO
						synchroWaitProto = (int) (dblFPS.getValue() * 0.5);  // delay = 500ms !! voir resol timer
						Display("Open shutter " + synchroWaitProto);

						cb_acqProto = true;		// = shutter ouvert
						sync.sendDTR(cb_acqProto);  // ouvrir shutter
					}
					SPACE = false;
				}
			}
			
			if (null == imp.getWindow()) {	if (syncSupp) sync.interrupt(); sync = null; Close(); break;} 
			switch(uBytesPerPixel) {
				case 4 : 
					if ( AOI_rect.cx < ImgSize.Width ) {
						for(int i = 0; i < AOI_rect.cy;i++)
							pcImgMem.read(i*ImgSize.Width*uBytesPerPixel, pix32, AOI_rect.x + (AOI_rect.y+i)*ImgSize.Width, AOI_rect.cx);
					} else 	pcImgMem.read(0, pix32, (AOI_rect.y*ImgSize.Width), uImageSize);
					break;
				case 2 : 
					if ( AOI_rect.cx < ImgSize.Width ) {
						for(int i = 0; i < AOI_rect.cy;i++)
							pcImgMem.read(i*ImgSize.Width*uBytesPerPixel, pix16, AOI_rect.x + (AOI_rect.y+i)*ImgSize.Width, AOI_rect.cx);
					} else 	pcImgMem.read(0, pix16, AOI_rect.y*ImgSize.Width, uImageSize);
					break;
				case 1 : 
					if ( AOI_rect.cx < ImgSize.Width ) {
						for(int i = 0; i < AOI_rect.cy;i++)
							pcImgMem.read(i*ImgSize.Width, pix8, AOI_rect.x + (AOI_rect.y+i)*ImgSize.Width, AOI_rect.cx);
					} else 	pcImgMem.read(0, pix8, (AOI_rect.y*ImgSize.Width), uImageSize);
			}
			Prefs.set("Cam.newImage",true);

			if (bsav && !end) {
				if (MaxImage>0) {
					MaxImage--;
					meta += timeStamp;
					dimp = imp.duplicate();
					ImageProcessor dip = dimp.getProcessor();
					dip.setRoi(AOI_rect.x,AOI_rect.y,AOI_rect.cx,AOI_rect.cy);
					ist.addSlice(meta, dip.crop());
					meta="";
				} else {
					// sync : switch off the LED
					if (cbi_rts == 3) 	sync.sendRTS(true);
					startRecording(82);
				}
			}

			if (!bsav || !bHide) imp.updateAndDraw();
			
			{
				--rdFPS;
				if (--rdFPS < 0) {
					ret = ueye.is_GetFramesPerSecond (pHIDS.getValue(), dblFPS);
					if (ret != IS_SUCCESS) st = "error";
					else {
						rdFPS = (int) Math.round(dblFPS.getValue()/2);
						st = String.format("%.1f fps", dblFPS.getValue());
					}
					lb_FPS.setText(st);
					if (bsav && !end) {
					// sync : switch on the LED
						if (cbi_rts == 3) 	sync.sendRTS(false);
						sb_left.setText("Recording " + MaxImage + " images");  /* */
					}
					if (autoGain) {
						gain = ueye.is_SetHWGainFactor(pHIDS.getValue(), 0x8000, gain); //IS_GET_MASTER_GAIN
						sl_gain.setValue(gain);
					}
					if (autoShutter) {
						DoubleByReference exp = new DoubleByReference();
						ueye.is_Exposure(pHIDS.getValue(), 7, exp.getPointer(), 8);	//IS_EXPOSURE_CMD_GET_EXPOSURE
						sl_expTime.setValue((int) (1000*exp.getValue()));
					}
				}
			}	
		}
		if (debug) Display("DEBUG:syncsupp="+syncSupp);
		if (syncSupp) {
		//	IJ.beep();
			sync.interrupt();
			sync = null;
		}
	}

	void loadDefaultValues() {
		ListCam = (boolean) Prefs.get("IDScam.ListCam",ListCam);
		calib = Prefs.get("IDScam.calib",calib);
		unit = Prefs.get("IDScam.unit",unit);
		autoGain = (boolean) Prefs.get("IDScam.autoGain",autoGain);
		expFPS = (int) Prefs.get("IDScam.expFPS",expFPS);
		LOOKANDFEEL = Prefs.get("IDScam.LaF",LOOKANDFEEL);
		syncSupp = (boolean) Prefs.get("IDScam.syncSupp",syncSupp);
		comPort = (int) Prefs.get("IDScam.comPort",comPort);
		debug = (boolean) Prefs.get("IDScam.debug",debug);
		
		Rgain  = (int) Prefs.get("IDScam.Rgain",Rgain);
		Ggain = (int) Prefs.get("IDScam.Ggain",Ggain);
		Bgain = (int) Prefs.get("IDScam.Bgain",Bgain);
		
		cb_sync = (boolean) Prefs.get("IDScam.cb_sync", cb_sync);
		cb_top = (boolean) Prefs.get("IDScam.cb_top", cb_top);
		cb_vidAcq =(boolean) Prefs.get("IDScam.cb_vidAcq", cb_vidAcq);
		cb_snap = (boolean) Prefs.get("IDScam.cb_snap", cb_snap);
		cb_beep = (boolean) Prefs.get("IDScam.cb_beep", cb_beep);
		cb_dtr  = (boolean) Prefs.get("IDScam.cb_dtr", cb_dtr);
		cbi_rts = (int) Prefs.get("IDScam.cbi_rts", cbi_rts);
		cbi_led = (int) Prefs.get("IDScam.cbi_led", cbi_led);
		cb_syncbip = (boolean) Prefs.get("IDScam.cb_syncbip", cb_syncbip);
	}

	void saveValues() {
		Prefs.set("IDScam.autoGain",autoGain);
		Prefs.set("IDScam.ListCam",ListCam);
		Prefs.set("IDScam.expFPS",expFPS);
		Prefs.set("IDScam.LaF",LOOKANDFEEL);
		Prefs.set("IDScam.syncSupp",syncSupp);
		Prefs.set("IDScam.comPort",comPort);
		Prefs.set("IDScam.debug",debug);
		
		Prefs.set("IDScam.Rgain",Rgain);
		Prefs.set("IDScam.Ggain",Ggain);
		Prefs.set("IDScam.Bgain",Bgain);
		
		Prefs.set("IDScam.cb_top", cb_top);
		Prefs.set("IDScam.cb_sync", cb_sync);
		Prefs.set("IDScam.cb_vidAcq", cb_vidAcq);
		Prefs.set("IDScam.cb_snap", cb_snap);
		Prefs.set("IDScam.cb_beep", cb_beep);
		Prefs.set("IDScam.cb_dtr", cb_dtr);
		Prefs.set("IDScam.cbi_rts", cbi_rts);
		Prefs.set("IDScam.cbi_led", cbi_led);
		Prefs.set("IDScam.cb_syncbip", cb_syncbip);
		
	}
	
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        int flags = e.getModifiers();
		ImagePlus nimp;
		// IJ.log("keyPressed: keyCode=" + keyCode + " (" + KeyEvent.getKeyText(keyCode) + ")");
		if (flags != 0) {
			IJ.getInstance().keyPressed(e); // hand off event to ImageJ
		}
		switch (keyCode) {
			case 67 : //C
			{
				if (setCM == IS_CM_RGBA8_PACKED) {
					if (colorDiag == null) 
						showColorDialog();
					else colorDiag.setVisible(true);
				}
			}
			case 69 : //E
				{
					UEYE.RECT.ByReference AOI_new = new UEYE.RECT.ByReference();
					Rectangle r = imp.getProcessor().getRoi();
					AOI_new.x = r.x;
					AOI_new.y = r.y;
					AOI_new.cx = r.width;
					AOI_new.cy = r.height;
					int ret = set_AOI_Rect(0x0030, AOI_new);		// IS_AOI_AUTO_BRIGHTNESS_SET_AOI
					if (ret != IS_SUCCESS) Display("ERROR - IS_AOI_AUTO_BRIGHTNESS_SET_AOI");
				}	break;
			case 32 : //SPACE
					SPACE = true;
					break; /* */
			case 27 : break;
			case 65 : // A
				{
					Rectangle r = imp.getProcessor().getRoi();
					lb_AOIX.setText(""+r.x/AOI_pos_inc.Width);
					setSlider(lb_AOIX, sl_AOIX); 
					int decal = r.x % AOI_pos_inc.Width;
					lb_AOIY.setText(""+r.y/AOI_pos_inc.Height);
					setSlider(lb_AOIY, sl_AOIY); 
					lb_AOICX.setText(""+(r.width<=AOI_size_min.Width?AOI_size_min.Width/AOI_size_inc.Width:(r.width+decal)/AOI_size_inc.Width));
					setSlider(lb_AOICX, sl_AOICX); 
					lb_AOICY.setText(""+(r.height<=AOI_size_min.Height?AOI_size_min.Height/AOI_size_inc.Height:r.height/AOI_size_inc.Height));
					// r.height/AOI_size_inc.Height);
					setSlider(lb_AOICY, sl_AOICY);
				} break;
			case 90 : //zoom
					int xCenter = AOI_rect.x + AOI_rect.cx / 2;
					int yCenter = AOI_rect.y + AOI_rect.cy / 2;
					IJ.run("Set... ", "x="+xCenter+" y="+yCenter);
				break;
			case 80 : // Pause
				if (bplay) {
					ueye.is_FreezeVideo(pHIDS.getValue(), 1);		// 1=IS_WAIT
					sb_left.setText("Paused");
				} else {
					ueye.is_CaptureVideo(pHIDS.getValue(), 1);	// Continue , 1=IS_WAIT  0=IS_DONT_WAIT
					sb_left.setText("Acquiring at " + getSpeed());
				}
				bplay = !bplay;
				break;
			case 83 : // Snap
				startRecording(keyCode);
				break;
			case 86: // Recording with all memory
			case 82: // Recording with frame/time number
				startRecording(keyCode);
				break; /* */ 
			default : IJ.getInstance().keyPressed(e); // hand off event to ImageJ
		}
    }
    public void keyReleased(KeyEvent e) {}
    public void keyTyped(KeyEvent e) {}
    
    public void imageOpened(ImagePlus imp) {}
    public void imageClosed(ImagePlus imp2) {
		if (imp2 == imp) {
			// if (debug) IJ.showMessage(""+imp2.getTitle()+" closed");
			Close();
			return;
		}
	}
    public void imageUpdated(ImagePlus imp) {}
	
	void Display(String st) {
		if (console) System.err.println(st);	else IJ.log(st);
	}

	void Close() {
		if (Active) {
			Active = false; // IJ.beep();
			IJ.wait(500);
			ueye.is_DisableEvent(pHIDS.getValue(), 0);
			if (isWindows()) {
				ueye.is_ExitEvent(pHIDS.getValue(), 0);
				Kernel32.INSTANCE.CloseHandle(hEvent);
			}
			if (imp != null) {
				Calibration cal = imp.getCalibration();
				if (cal.pixelWidth != calib*setDiv)	{
					unit = cal.getUnit();
					calib = cal.pixelWidth/setDiv;
					// IJ.showMessage("New Calib :" + calib + unit);
					calibChanged = true;
				}
			}
			if (calibChanged)
				if (IJ.showMessageWithCancel("Settings", "Calibration changed, replace?")) 
				{
					Prefs.set("IDScam.calib",calib);
					Prefs.set("IDScam.unit",unit);
				}
			saveValues();
			int ret = ueye.is_StopLiveVideo(pHIDS.getValue(), 1);		//IS_WAIT
			if (ret != IS_SUCCESS) Display("ERROR - IS_StopLive");

			if (ppcImgMem != null) {
				ret = ueye.is_FreeImageMem(pHIDS.getValue(), ppcImgMem.getValue(), pid.getValue());
				if (ret != IS_SUCCESS) Display("ERROR - IS_FreeImageMem"); /**/
				else Display("SUCCES - Free Image Memory");
			}		
			
			ret = ueye.is_ExitCamera(pHIDS.getValue());
			if (ret != IS_SUCCESS) Display("ERROR - Closing IDS Cam");
			else Display("SUCCES - Closing IDS Cam");
		}
		if (colorDiag != null)
			colorDiag.dispose();
		if (dialog!=null)
			dialog.dispose();
        if (win!=null)
            win.removeKeyListener(this);
        if (canvas!=null)
            canvas.removeKeyListener(this);
	}
}
