/*
 * Decompiled with CFR 0.152.
 */
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IJ_IDS_Cam
implements PlugIn,
KeyListener,
ChangeListener,
ActionListener,
ItemListener,
ImageListener {
    boolean debug = true;
    ImageWindow win;
    ImageCanvas canvas;
    String sVer = "IDS Cam Control ver. 1.3";
    String sCop = "Copyright \u00a9 2015-2018 F.GANNIER - C.PASQUALIN";
    public static final int IS_SUCCESS = 0;
    public static final int IS_NO_SUCCESS = -1;
    public static final int IS_GET_BINNING = 32768;
    public static final int IS_GET_SUPPORTED_BINNING = 32769;
    public static final int IS_BINNING_2X = 3;
    public static final int IS_BINNING_3X = 48;
    public static final int IS_BINNING_4X = 12;
    public static final int IS_BINNING_5X = 192;
    public static final int IS_BINNING_6X = 768;
    public static final int IS_BINNING_8X = 3072;
    public static final int IS_BINNING_16X = 12288;
    public static final int IS_GET_SUBSAMPLING = 32768;
    public static final int IS_GET_SUPPORTED_SUBSAMPLING = 32769;
    public static final int IS_SUBSAMPLING_2X = 3;
    public static final int IS_SUBSAMPLING_4X = 12;
    public static final int IS_SUBSAMPLING_3X = 48;
    public static final int IS_SUBSAMPLING_5X = 192;
    public static final int IS_SUBSAMPLING_6X = 768;
    public static final int IS_SUBSAMPLING_8X = 3072;
    public static final int IS_SUBSAMPLING_16X = 12288;
    public static final int IS_CM_SENSOR_RAW8 = 11;
    public static final int IS_CM_MONO8 = 6;
    public static final int IS_CM_SENSOR_RAW10 = 33;
    public static final int IS_CM_MONO10 = 34;
    public static final int IS_CM_MONO12 = 26;
    public static final int IS_CM_SENSOR_RAW12 = 27;
    public static final int IS_CM_MONO16 = 28;
    public static final int IS_CM_SENSOR_RAW16 = 29;
    public static final int IS_CM_BGRA8_PACKED = 128;
    public static final int IS_CM_RGBA8_PACKED = 0;
    public static final int IS_SET_EVENT_FRAME = 2;
    public static final int IS_SET_AUTO_REFERENCE = 32768;
    public static final int IS_GET_AUTO_REFERENCE = 32769;
    public static final int IS_SET_ENABLE_AUTO_GAIN = 34816;
    public static final int IS_GET_ENABLE_AUTO_GAIN = 34817;
    public static final int IS_SET_ENABLE_AUTO_SHUTTER = 34818;
    public static final int IS_SET_ENABLE_AUTO_WHITEBALANCE = 34820;
    public static final int IS_SET_ENABLE_AUTO_FRAMERATE = 34822;
    public static final int IS_SET_ENABLE_AUTO_SENSOR_GAIN = 34824;
    public static final int IS_SET_ENABLE_AUTO_SENSOR_SHUTTER = 34832;
    public static final int IS_SET_ENABLE_AUTO_SENSOR_GAIN_SHUTTER = 34834;
    public static final int IS_SET_ENABLE_AUTO_SENSOR_FRAMERATE = 34836;
    public static final int IS_SET_ENABLE_AUTO_SENSOR_WHITEBALANCE = 34838;
    public static final int IS_USE_DEVICE_ID = 32768;
    UEYE ueye;
    ImagePlus imp;
    ImageProcessor ip;
    ImageStack ist;
    WinNT.HANDLE hEvent;
    boolean Active = false;
    listenCOM sync = null;
    boolean syncSupp;
    boolean RTSsync = false;
    int comPort = 1;
    byte[] pix8;
    short[] pix16;
    int[] pix32;
    boolean console = false;
    String st;
    int NumCam = -1;
    int MaxWidth = -1;
    int MaxHeight = -1;
    int vDiv = 1;
    int hDiv = 1;
    String ModelName;
    int usb = 0;
    int setCM = 6;
    String stCM = "8-bit Black";
    int bitspixel = 8;
    int uBytesPerPixel;
    int uImageSize;
    boolean AOIsupp = false;
    int binningMode = -1;
    int binningSupp = -1;
    int subSamplingMode = -1;
    int subSamplingSupp = -1;
    boolean boostGainSupp = false;
    boolean boostGain = false;
    boolean color = false;
    int Nbinning = 0;
    int NsubSampling = 0;
    int setBinning = 0;
    int setsubSampling = 0;
    int setDiv = 1;
    int nImage = 0;
    private int gain = 200;
    private int Rgain = 142;
    private int Ggain = 104;
    private int Bgain = 375;
    double calib = 1.0;
    String unit = "micron";
    boolean calibChanged = false;
    boolean autoGain = true;
    boolean bHide = false;
    boolean autoShutter = true;
    boolean autoWB = false;
    boolean ListCam = false;
    boolean bSync = false;
    boolean bplay = true;
    boolean bsav = false;
    boolean cb_sync = true;
    boolean cb_top = true;
    boolean cb_vidAcq = false;
    boolean cb_snap = false;
    boolean cb_proto = false;
    int proto_periode = 10;
    int delay = 0;
    boolean cb_beep = true;
    boolean cb_dtr = false;
    int cbi_rts = 0;
    int cbi_led = 0;
    boolean cb_syncbip = false;
    int nVideo = 0;
    int expFPS = 25;
    IntByReference pPxlClk = new IntByReference();
    Pointer arrayClock;
    int maxClock;
    int minClock;
    int incClock;
    int nbInc;
    static int DLL_VER_MAJOR = 4;
    static int DLL_VER_MINOR = 6;
    IntByReference pHIDS;
    PointerByReference ppcImgMem;
    Pointer pcImgMem;
    IntByReference pid;
    DoubleByReference enable = new DoubleByReference();
    DoubleByReference disable = new DoubleByReference();
    DoubleByReference dblFPS = new DoubleByReference();
    int Skip_Frame_max;
    int Skip_Frame_min;
    UEYE.IS_SIZE2D ImgSize;
    UEYE.RECT AOI_rect;
    UEYE.IS_SIZE2D AOI_pos_inc;
    UEYE.IS_SIZE2D AOI_size_inc;
    UEYE.IS_SIZE2D AOI_pos_min;
    UEYE.IS_SIZE2D AOI_size_min;
    long MaxImage;
    long StartTime;
    boolean end = false;
    boolean SPACE = false;
    private static String OS = System.getProperty("os.name").toLowerCase();
    String LOOKANDFEEL = "Nimbus";
    protected JSlider sl_gain;
    protected JSlider sl_expFPS;
    protected JSlider sl_pxlclk;
    protected JSlider sl_expTime;
    protected JSlider sl_AOIX;
    protected JSlider sl_AOIY;
    protected JSlider sl_AOICX;
    protected JSlider sl_AOICY;
    protected JSlider sl_brightRef;
    protected JSlider sl_image;
    protected JSlider sl_time;
    protected JTextField lb_gain;
    protected JTextField lb_expFPS;
    protected JTextField lb_pxlclk;
    protected JTextField lb_expTime;
    protected JTextField lb_AOIX;
    protected JTextField lb_AOIY;
    protected JTextField lb_AOICX;
    protected JTextField lb_AOICY;
    protected JTextField lb_brightRef;
    protected JTextField lb_image;
    protected JTextField lb_time;
    protected JSlider sl_Rgain;
    protected JSlider sl_Bgain;
    protected JSlider sl_Ggain;
    protected JTextField lb_Rgain;
    protected JTextField lb_Bgain;
    protected JTextField lb_Ggain;
    protected JCheckBox bxGain;
    protected JCheckBox bxBoost;
    protected JCheckBox bxShutter;
    protected JCheckBox bxHide;
    protected JDialog dialog;
    protected JLabel lb_FPS;
    protected JLabel sb_left;
    protected JLabel sb_center;
    protected JButton bt_right;
    int reentry = 0;
    protected JDialog colorDiag;

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private void initLookAndFeel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (IJ_IDS_Cam.this.debug) {
                            IJ_IDS_Cam.this.Display(info.getName());
                        }
                        if (!IJ_IDS_Cam.this.LOOKANDFEEL.equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    JSlider addSlider(JPanel panel, String Name, JTextField val, int minV, int max, int dflt) {
        JSlider slider = new JSlider();
        slider = new JSlider(0, minV, max, dflt < max ? dflt : max);
        slider.setMinorTickSpacing((max - minV) / 10);
        slider.setMajorTickSpacing((max - minV) / 2);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        JPanel ValPanel = new JPanel();
        ValPanel.setLayout(new FlowLayout(4, 5, 3));
        Label label = new Label(Name);
        ValPanel.add(label);
        val.setHorizontalAlignment(0);
        val.setText("" + (dflt < max ? dflt : max));
        val.addActionListener(this);
        ValPanel.add(val);
        panel.add(ValPanel);
        panel.add(slider);
        slider.addChangeListener(this);
        return slider;
    }

    public JCheckBox addCheckBox(JPanel panel, String Name, boolean dflt) {
        JCheckBox bxTemp = new JCheckBox(Name, dflt);
        panel.add(bxTemp);
        bxTemp.addItemListener(this);
        return bxTemp;
    }

    protected String getSpeed() {
        int debit = this.uBytesPerPixel * this.uImageSize * this.expFPS / 900;
        if (debit > 10000) {
            return "" + debit / 1000 + "MB/s (USB" + this.usb + ")";
        }
        return "" + debit + "KB/s (USB" + this.usb + ")";
    }

    protected void TF_enable(boolean b, JTextField TF) {
        TF.setEditable(b);
        TF.setForeground(b ? null : Color.LIGHT_GRAY);
    }

    private void setSlider(JTextField tf, JSlider sl) {
        String st = tf.getText();
        int oldval = sl.getValue();
        int newval = 0;
        try {
            newval = Integer.parseInt(st);
        }
        catch (NumberFormatException error) {
            tf.setText("" + oldval);
            return;
        }
        int min = sl.getMinimum();
        int max = sl.getMaximum();
        if (newval >= min && newval <= max) {
            if (newval != oldval) {
                sl.setValue(newval);
            }
        } else {
            tf.setText("" + oldval);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int val;
        Object origin = e.getSource();
        if (origin == this.lb_gain) {
            this.setSlider(this.lb_gain, this.sl_gain);
        }
        if (origin == this.lb_Rgain) {
            this.setSlider(this.lb_Rgain, this.sl_Rgain);
        }
        if (origin == this.lb_Ggain) {
            this.setSlider(this.lb_Ggain, this.sl_Ggain);
        }
        if (origin == this.lb_Bgain) {
            this.setSlider(this.lb_Bgain, this.sl_Bgain);
        }
        if (origin == this.lb_expFPS) {
            this.setSlider(this.lb_expFPS, this.sl_expFPS);
        }
        if (origin == this.lb_pxlclk) {
            this.setSlider(this.lb_pxlclk, this.sl_pxlclk);
        }
        if (origin == this.lb_expTime) {
            this.setSlider(this.lb_expTime, this.sl_expTime);
        }
        if (origin == this.lb_AOIX) {
            this.setSlider(this.lb_AOIX, this.sl_AOIX);
        }
        if (origin == this.lb_AOIY) {
            this.setSlider(this.lb_AOIY, this.sl_AOIY);
        }
        if (origin == this.lb_AOICX) {
            this.setSlider(this.lb_AOICX, this.sl_AOICX);
        }
        if (origin == this.lb_AOICY) {
            this.setSlider(this.lb_AOICY, this.sl_AOICY);
        }
        if (origin == this.lb_brightRef) {
            this.setSlider(this.lb_brightRef, this.sl_brightRef);
        }
        if (origin == this.lb_time) {
            this.setSlider(this.lb_time, this.sl_time);
            val = (int)((double)this.sl_time.getValue() * this.dblFPS.getValue());
            this.lb_image.setText("" + val);
            this.sl_image.setValue(val);
        }
        if (origin == this.lb_image) {
            this.setSlider(this.lb_image, this.sl_image);
            val = (int)((double)this.sl_image.getValue() / this.dblFPS.getValue());
            this.lb_time.setText("" + val);
            this.sl_time.setValue(val);
        }
        if (origin == this.bt_right) {
            GenericDialog gd = new GenericDialog("Set sync options");
            gd.setInsets(5, 5, 0);
            gd.addMessage("DSR IN pulse");
            gd.setInsets(0, 20, 0);
            gd.addCheckbox("Add metadata \"sync\" to image", this.cb_sync);
            gd.addCheckbox("beep", this.cb_syncbip);
            gd.setInsets(15, 5, 0);
            gd.addMessage("CTS IN pulse");
            gd.addCheckbox("Add metadata \"top\" to image", this.cb_top);
            gd.addCheckbox("Start/Stop video Acquisition", this.cb_vidAcq);
            gd.addCheckbox("Take a picture", this.cb_snap);
            gd.addNumericField("    With a delay of", (double)this.delay, 0, 3, "s");
            gd.addCheckbox("beep", this.cb_beep);
            String[] choice1 = new String[4];
            int n = 0;
            choice1[n++] = "do nothing";
            choice1[n++] = "switch at  each new image";
            choice1[n++] = "switch at  each new sync on DSR";
            choice1[n++] = "when recording video";
            gd.setInsets(15, 5, 0);
            gd.addChoice("RTS OUT pulse", choice1, choice1[this.cbi_rts]);
            gd.setInsets(15, 5, 0);
            gd.addMessage("DTR OUT pulse");
            gd.addMessage("Add metadata \"mark\" to image when SPACE is pressed");
            gd.addCheckbox("When SPACE is pressed", this.cb_dtr);
            gd.addCheckbox("Active Proto with SPACE", this.cb_proto);
            gd.addNumericField("    With a periode of", (double)this.proto_periode, 0, 3, "s");
            String[] choice0 = new String[3];
            n = 0;
            choice0[n++] = "do nothing";
            choice0[n++] = "each new image";
            choice0[n++] = "each sync on DSR";
            gd.setInsets(15, 5, 0);
            gd.addChoice("Flash Camera led", choice0, choice0[this.cbi_led]);
            gd.showDialog();
            this.cb_sync = gd.getNextBoolean();
            this.cb_syncbip = gd.getNextBoolean();
            this.cb_top = gd.getNextBoolean();
            this.cb_vidAcq = gd.getNextBoolean();
            this.cb_snap = gd.getNextBoolean();
            this.delay = (int)gd.getNextNumber();
            this.cb_beep = gd.getNextBoolean();
            this.cbi_rts = gd.getNextChoiceIndex();
            this.cb_dtr = gd.getNextBoolean();
            this.cb_proto = gd.getNextBoolean();
            this.proto_periode = (int)gd.getNextNumber();
            this.cbi_led = gd.getNextChoiceIndex();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object origin = e.getSource();
        if (origin == this.bxShutter) {
            this.autoShutter = this.bxShutter.isSelected();
            if (this.autoShutter) {
                this.TF_enable(false, this.lb_expTime);
            } else {
                this.TF_enable(true, this.lb_expTime);
            }
            this.setAutoShutter(this.autoShutter, this.sl_expTime.getValue());
        }
        if (origin == this.bxGain) {
            this.autoGain = this.bxGain.isSelected();
            if (this.autoGain) {
                this.TF_enable(false, this.lb_gain);
            } else {
                this.TF_enable(true, this.lb_gain);
            }
            this.setAutoGain(this.autoGain, this.gain);
        }
        if (origin == this.bxHide) {
            this.bHide = this.bxHide.isSelected();
        }
        if (origin == this.bxBoost) {
            this.boostGain = this.bxBoost.isSelected();
            if (this.boostGain) {
                if (0 == this.ueye.is_SetGainBoost(this.pHIDS.getValue(), 32776)) {
                    this.ueye.is_SetGainBoost(this.pHIDS.getValue(), 1);
                }
            } else if (1 == this.ueye.is_SetGainBoost(this.pHIDS.getValue(), 32776)) {
                this.ueye.is_SetGainBoost(this.pHIDS.getValue(), 0);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int maxV;
        int minV;
        int ret;
        int val;
        Object origin = e.getSource();
        boolean b_ETchge = false;
        boolean b_FPSchge = false;
        boolean b_FPSupdate = false;
        ++this.reentry;
        if (this.reentry > 1) {
            --this.reentry;
            return;
        }
        if (origin == this.sl_image) {
            this.lb_image.setText("" + this.sl_image.getValue());
            val = (int)((double)this.sl_image.getValue() / this.dblFPS.getValue());
            this.lb_time.setText("" + val);
            this.sl_time.setValue(val);
        }
        if (origin == this.sl_time) {
            this.lb_time.setText("" + this.sl_time.getValue());
            val = (int)((double)this.sl_time.getValue() * this.dblFPS.getValue());
            this.lb_image.setText("" + val);
            this.sl_image.setValue(val);
        }
        if (origin == this.sl_brightRef) {
            DoubleByReference pval = new DoubleByReference();
            pval.setValue((double)this.sl_brightRef.getValue());
            this.lb_brightRef.setText("" + pval.getValue());
            this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 32768, pval, this.disable);
        }
        if (origin == this.sl_gain) {
            this.gain = this.sl_gain.getValue();
            this.lb_gain.setText("" + this.gain);
            if (!this.autoGain) {
                this.setAutoGain(this.autoGain, this.gain);
            }
        }
        if (origin == this.sl_Rgain) {
            this.Rgain = this.sl_Rgain.getValue();
            this.lb_Rgain.setText("" + this.Rgain);
            this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32773, this.Rgain);
        }
        if (origin == this.sl_Ggain) {
            this.Ggain = this.sl_Ggain.getValue();
            this.lb_Ggain.setText("" + this.Ggain);
            this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32774, this.Ggain);
        }
        if (origin == this.sl_Bgain) {
            this.Bgain = this.sl_Bgain.getValue();
            this.lb_Bgain.setText("" + this.Bgain);
            this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32775, this.Bgain);
        }
        if (origin == this.sl_expFPS) {
            this.expFPS = this.sl_expFPS.getValue();
            this.lb_expFPS.setText("" + this.expFPS);
            b_ETchge = true;
            b_FPSchge = true;
        }
        if (origin == this.sl_pxlclk) {
            int oldValue = this.pPxlClk.getValue();
            int i = 0;
            while (oldValue > this.arrayClock.getInt((long)(4 * i))) {
                ++i;
            }
            int pxclk = this.sl_pxlclk.getValue();
            if (pxclk != oldValue) {
                if (pxclk > this.arrayClock.getInt((long)(4 * i))) {
                    pxclk = this.arrayClock.getInt((long)(4 * (i + 1)));
                }
                if (pxclk < this.arrayClock.getInt((long)(4 * i))) {
                    pxclk = this.arrayClock.getInt((long)(4 * (i - 1)));
                }
                this.pPxlClk.setValue(pxclk);
                this.ueye.is_PixelClock(this.pHIDS.getValue(), 6, this.pPxlClk.getPointer(), 4);
            }
            this.sl_pxlclk.setValue(pxclk);
            this.lb_pxlclk.setText("" + pxclk);
            b_FPSupdate = true;
            b_ETchge = true;
            b_FPSchge = true;
        }
        if (origin == this.sl_expTime) {
            int expTime = this.sl_expTime.getValue();
            this.lb_expTime.setText("" + expTime);
            if (!this.autoShutter) {
                this.setAutoShutter(this.autoShutter, expTime);
            }
        }
        UEYE.RECT.ByReference AOI_new = new UEYE.RECT.ByReference();
        if (origin == this.sl_AOIX || origin == this.sl_AOIY || origin == this.sl_AOICX || origin == this.sl_AOICY) {
            int AOIX = this.sl_AOIX.getValue();
            AOI_new.x = AOIX * this.AOI_pos_inc.Width;
            int AOIY = this.sl_AOIY.getValue();
            AOI_new.y = AOIY * this.AOI_pos_inc.Height;
            int AOICX = this.sl_AOICX.getValue();
            AOI_new.cx = AOICX * this.AOI_size_inc.Width;
            int AOICY = this.sl_AOICY.getValue();
            AOI_new.cy = AOICY * this.AOI_size_inc.Height;
            if (AOI_new.x + AOI_new.cx > this.ImgSize.Width) {
                AOI_new.cx = this.ImgSize.Width - AOI_new.x;
            }
            if (AOI_new.y + AOI_new.cy > this.ImgSize.Height) {
                AOI_new.cy = this.ImgSize.Height - AOI_new.y;
            }
            this.lb_AOIX.setText("" + AOIX);
            this.lb_AOIY.setText("" + AOIY);
            this.lb_AOICX.setText("" + AOICX);
            this.lb_AOICY.setText("" + AOICY);
            if (this.reentry > 1) {
                --this.reentry;
                return;
            }
            ret = this.set_AOI_Rect(1, AOI_new);
            this.AOI_rect = AOI_new;
            this.uImageSize = this.AOI_rect.cx * this.AOI_rect.cy;
            switch (this.uBytesPerPixel) {
                case 4: {
                    int i;
                    for (i = 0; i < this.ImgSize.Width * this.ImgSize.Height; ++i) {
                        this.pix32[i] = 0;
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < this.ImgSize.Width * this.ImgSize.Height; ++i) {
                        this.pix16[i] = 0;
                    }
                    break;
                }
                case 1: {
                    int i;
                    for (i = 0; i < this.ImgSize.Width * this.ImgSize.Height; ++i) {
                        this.pix8[i] = 0;
                    }
                    break;
                }
            }
            b_FPSchge = true;
            b_FPSupdate = true;
        }
        if (b_FPSupdate) {
            DoubleByReference minFPS = new DoubleByReference();
            DoubleByReference maxFPS = new DoubleByReference();
            DoubleByReference intFPS = new DoubleByReference();
            ret = this.ueye.is_GetFrameTimeRange(this.pHIDS.getValue(), minFPS, maxFPS, intFPS);
            minV = (int)(1.0 / maxFPS.getValue());
            maxV = (int)(1.0 / minFPS.getValue());
            this.sl_expFPS.setMaximum(maxV);
            this.sl_expFPS.setMinimum(minV);
            this.sl_expFPS.setLabelTable(null);
            this.sl_expFPS.setMinorTickSpacing((maxV - minV) / 10);
            this.sl_expFPS.setMajorTickSpacing((maxV - minV) / 2);
            this.sb_left.setText("Acquiring at " + this.getSpeed());
        }
        if (b_ETchge) {
            DoubleByReference exp = new DoubleByReference();
            this.ueye.is_Exposure(this.pHIDS.getValue(), 7, exp.getPointer(), 8);
            DoubleByReference expMin = new DoubleByReference();
            DoubleByReference expMax = new DoubleByReference();
            this.ueye.is_Exposure(this.pHIDS.getValue(), 3, expMin.getPointer(), 8);
            this.ueye.is_Exposure(this.pHIDS.getValue(), 3, expMin.getPointer(), 8);
            this.ueye.is_Exposure(this.pHIDS.getValue(), 4, expMax.getPointer(), 8);
            minV = (int)(1000.0 * expMin.getValue());
            maxV = (int)(1000.0 * expMax.getValue());
            this.sl_expTime.setMaximum(maxV);
            this.sl_expTime.setMinimum(minV);
            this.sl_expTime.setLabelTable(null);
            this.sl_expTime.setMinorTickSpacing((maxV - minV) / 10);
            this.sl_expTime.setMajorTickSpacing((maxV - minV) / 2);
        }
        if (b_FPSchge) {
            if (this.expFPS / 10 < this.Skip_Frame_min && this.expFPS / 10 > this.Skip_Frame_min) {
                DoubleByReference pval = new DoubleByReference();
                pval.setValue((double)(this.expFPS / 10));
                ret = this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 32792, pval, this.disable);
                if (ret != 0) {
                    this.Display("ERROR - is_SetAuto skipframes : " + ret);
                }
            }
            DoubleByReference pFPS = new DoubleByReference();
            this.ueye.is_SetFrameRate(this.pHIDS.getValue(), this.expFPS, pFPS);
            this.sb_left.setText("Acquiring at " + this.getSpeed());
        }
        --this.reentry;
    }

    public void showControlDialog() {
        int haut = 550;
        this.dialog = new JDialog();
        ImageIcon img = new ImageIcon(this.getClass().getResource("/ueye.png"));
        this.dialog.setIconImage(img.getImage());
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel ChkPanel = new JPanel();
        this.bxGain = this.addCheckBox(ChkPanel, "Gain auto", this.autoGain);
        this.bxShutter = this.addCheckBox(ChkPanel, "Shutter auto", this.autoShutter);
        if (this.boostGainSupp) {
            this.bxBoost = this.addCheckBox(ChkPanel, "Gain Boost", this.boostGain);
        } else {
            JLabel tp = new JLabel("");
            ChkPanel.add(tp);
        }
        this.bxHide = this.addCheckBox(ChkPanel, "Vis. off", this.bHide);
        centerPanel.add((Component)ChkPanel, "North");
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new GridLayout(0, 2));
        int maxGain = this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32780, 100);
        this.gain = this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32768, this.gain);
        this.lb_gain = new JTextField(4);
        this.sl_gain = this.addSlider(sliderPanel, "Gain : ", this.lb_gain, 1, maxGain, this.gain);
        if (this.autoGain) {
            this.TF_enable(false, this.lb_gain);
        }
        if (this.setCM == 0) {
            this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32773, this.Rgain);
            this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32774, this.Ggain);
            this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32775, this.Bgain);
        }
        this.ueye.is_PixelClock(this.pHIDS.getValue(), 5, this.pPxlClk.getPointer(), 4);
        this.lb_expFPS = new JTextField(4);
        DoubleByReference minFPS = new DoubleByReference();
        DoubleByReference maxFPS = new DoubleByReference();
        DoubleByReference intFPS = new DoubleByReference();
        int ret = this.ueye.is_GetFrameTimeRange(this.pHIDS.getValue(), minFPS, maxFPS, intFPS);
        this.Display("Time Range : " + (int)(1.0 / maxFPS.getValue()) + " : " + (int)(1.0 / minFPS.getValue()));
        this.sl_expFPS = this.addSlider(sliderPanel, "Expected fps : ", this.lb_expFPS, (int)(1.0 / maxFPS.getValue()), (int)(1.0 / minFPS.getValue()), this.expFPS);
        this.lb_pxlclk = new JTextField(4);
        this.sl_pxlclk = this.addSlider(sliderPanel, "Pixel clock : ", this.lb_pxlclk, this.minClock, this.maxClock, this.pPxlClk.getValue());
        DoubleByReference exp = new DoubleByReference();
        this.ueye.is_Exposure(this.pHIDS.getValue(), 7, exp.getPointer(), 8);
        DoubleByReference expMin = new DoubleByReference();
        DoubleByReference expMax = new DoubleByReference();
        this.ueye.is_Exposure(this.pHIDS.getValue(), 3, expMin.getPointer(), 8);
        this.ueye.is_Exposure(this.pHIDS.getValue(), 3, expMin.getPointer(), 8);
        this.ueye.is_Exposure(this.pHIDS.getValue(), 4, expMax.getPointer(), 8);
        this.Display("INFO - is_Exposure range " + expMin.getValue() + "-" + expMax.getValue());
        this.lb_expTime = new JTextField(4);
        this.sl_expTime = this.addSlider(sliderPanel, "Exposure time (us) : ", this.lb_expTime, (int)(1000.0 * expMin.getValue()), (int)(1000.0 * expMax.getValue()), (int)(1000.0 * exp.getValue()));
        if (this.autoShutter) {
            this.TF_enable(false, this.lb_expTime);
        }
        this.lb_brightRef = new JTextField(4);
        this.sl_brightRef = this.addSlider(sliderPanel, "Brightness Ref. : ", this.lb_brightRef, 0, 255, 128);
        if (this.AOIsupp) {
            this.lb_AOIX = new JTextField(4);
            this.sl_AOIX = this.addSlider(sliderPanel, "AOI X step : ", this.lb_AOIX, this.AOI_pos_min.Width / this.AOI_pos_inc.Width, this.MaxWidth / this.hDiv / this.AOI_pos_inc.Width, 0);
            this.lb_AOIY = new JTextField(4);
            this.sl_AOIY = this.addSlider(sliderPanel, "AOI Y step : ", this.lb_AOIY, this.AOI_pos_min.Height / this.AOI_pos_inc.Height, this.MaxHeight / this.vDiv / this.AOI_pos_inc.Height, 0);
            this.lb_AOICX = new JTextField(4);
            this.sl_AOICX = this.addSlider(sliderPanel, "AOI CX step : ", this.lb_AOICX, this.AOI_size_min.Width / this.AOI_size_inc.Width, this.MaxWidth / this.hDiv / this.AOI_size_inc.Width, this.MaxWidth / this.hDiv / this.AOI_size_inc.Width);
            this.lb_AOICY = new JTextField(4);
            this.sl_AOICY = this.addSlider(sliderPanel, "AOI CY step : ", this.lb_AOICY, this.AOI_size_min.Height / this.AOI_size_inc.Height, this.MaxHeight / this.vDiv / this.AOI_size_inc.Height, this.MaxHeight / this.vDiv / this.AOI_size_inc.Height);
        }
        DoubleByReference max = new DoubleByReference();
        DoubleByReference min = new DoubleByReference();
        this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 32794, min, max);
        this.Display("INFO : IS_GET_AUTO_SKIPFRAMES_RANGE (" + min.getValue() + "," + max.getValue() + ")");
        min.setValue((double)this.Skip_Frame_min);
        max.setValue((double)this.Skip_Frame_max);
        centerPanel.add((Component)sliderPanel, "Center");
        JLabel HelpTxt = new JLabel("<html><center><b>Do not changed Size or ROI during Recording !!!<BR>Shortcut </b>: <b>P</b>ause - <b>S</b>nap - <b>Z</b>oom on <b>A</b>OI - A<b>E</b>S on ROI - Start/Stop <b>R</b>ecording<BR></center></html>", 0);
        this.dialog.add((Component)HelpTxt, "North");
        centerPanel.add((Component)new JLabel(this.sCop), "South");
        this.dialog.add((Component)centerPanel, "Center");
        if (!this.syncSupp) {
            this.bt_right = new JButton("");
        } else {
            this.bt_right = new JButton("Set Sync Options");
            AffineTransform at = this.bt_right.getFont().getTransform();
            at.rotate(1.5707963267948966);
            Font font = this.bt_right.getFont().deriveFont(at);
            this.bt_right.setFont(font);
            this.bt_right.setVerticalAlignment(0);
            this.bt_right.addActionListener(this);
        }
        this.bt_right.setBorderPainted(false);
        this.bt_right.setFocusPainted(false);
        if (this.syncSupp) {
            this.bt_right.setEnabled(true);
        } else {
            this.bt_right.setEnabled(false);
        }
        this.dialog.add((Component)this.bt_right, "East");
        JStatusBar statusBar = new JStatusBar();
        this.sb_left = new JLabel("Acquiring at " + this.getSpeed());
        statusBar.setLeftComponent(this.sb_left);
        this.sb_center = new JLabel(this.ModelName.substring(0, 14));
        this.sb_center.setHorizontalAlignment(0);
        statusBar.addRightComponent(this.sb_center);
        this.lb_FPS = new JLabel();
        this.lb_FPS.setHorizontalAlignment(0);
        statusBar.addRightComponent(this.lb_FPS);
        this.dialog.add((Component)statusBar, "South");
        this.dialog.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation(screen.width - 450, screen.height - haut - 50);
        this.dialog.setSize(450, haut);
        this.dialog.setTitle(this.sVer);
        this.dialog.setModal(false);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.setVisible(true);
    }

    public void showColorDialog() {
        this.colorDiag = new JDialog();
        ImageIcon img = new ImageIcon(this.getClass().getResource("/ueye.png"));
        this.colorDiag.setIconImage(img.getImage());
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new GridLayout(0, 2));
        this.Rgain = this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32769, this.Rgain);
        this.Ggain = this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32770, this.Ggain);
        this.Bgain = this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32771, this.Bgain);
        int maxGain = this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32781, 100);
        this.lb_Rgain = new JTextField(4);
        this.sl_Rgain = this.addSlider(sliderPanel, "Red : ", this.lb_Rgain, 1, maxGain, this.Rgain);
        maxGain = this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32782, 100);
        this.lb_Ggain = new JTextField(4);
        this.sl_Ggain = this.addSlider(sliderPanel, "Green : ", this.lb_Ggain, 1, maxGain, this.Ggain);
        maxGain = this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32783, 100);
        this.lb_Bgain = new JTextField(4);
        this.sl_Bgain = this.addSlider(sliderPanel, "Blue : ", this.lb_Bgain, 1, maxGain, this.Bgain);
        centerPanel.add((Component)sliderPanel, "Center");
        JLabel HelpTxt = new JLabel(" ", 0);
        this.colorDiag.add((Component)HelpTxt, "North");
        this.colorDiag.add((Component)centerPanel, "Center");
        this.colorDiag.add((Component)new JLabel("  \t  "), "East");
        JStatusBar statusBar = new JStatusBar();
        statusBar.setLeftComponent(new JLabel(this.sCop));
        this.colorDiag.add((Component)statusBar, "South");
        this.colorDiag.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.colorDiag.setLocation(screen.width / 2, screen.height / 2);
        this.colorDiag.setSize(450, 200);
        this.colorDiag.setTitle(this.sVer);
        this.colorDiag.setModal(false);
        this.colorDiag.setDefaultCloseOperation(1);
        this.colorDiag.setVisible(true);
    }

    int showInitDialog() {
        boolean syncTest;
        String[] choice;
        GenericDialog gd = new GenericDialog(this.sVer);
        gd.addNumericField("Calibration for X1:", this.calib, 8, 12, "unit/px");
        gd.addStringField("unit:", this.unit);
        gd.addCheckbox("Gain Auto", this.autoGain);
        if (this.color) {
            gd.addCheckbox("Auto White balance", this.autoWB);
        }
        gd.addNumericField("Expected FPS", (double)this.expFPS, 0);
        String[] choice0 = new String[5];
        int n = 0;
        choice0[n++] = "Mono 8 bits";
        choice0[n++] = "Mono 10 bits";
        choice0[n++] = "Mono 12 bits";
        choice0[n++] = "Mono 16 bits";
        choice0[n++] = "RGB 8 bits";
        gd.addChoice("Mono / Color Mode", choice0, choice0[0]);
        boolean b_LUT = false;
        if (this.binningSupp > 0) {
            n = 0;
            choice = new String[this.Nbinning + 1];
            choice[n++] = "x1";
            if ((this.binningSupp & 3) > 0) {
                choice[n++] = "x2";
            }
            if ((this.binningSupp & 0x30) > 0) {
                choice[n++] = "x3";
            }
            if ((this.binningSupp & 0xC) > 0) {
                choice[n++] = "x4";
            }
            if ((this.binningSupp & 0xC0) > 0) {
                choice[n++] = "x5";
            }
            if ((this.binningSupp & 0x300) > 0) {
                choice[n++] = "x6";
            }
            if ((this.binningSupp & 0xC00) > 0) {
                choice[n++] = "x8";
            }
            if ((this.binningSupp & 0x3000) > 0) {
                choice[n++] = "x16";
            }
            gd.addChoice("Binning Mode", choice, choice[0]);
        }
        if (this.subSamplingSupp > 0) {
            n = 0;
            choice = new String[this.NsubSampling + 1];
            choice[n++] = "x1";
            if ((this.subSamplingSupp & 3) > 0) {
                choice[n++] = "x2";
            }
            if ((this.subSamplingSupp & 0x30) > 0) {
                choice[n++] = "x3";
            }
            if ((this.subSamplingSupp & 0xC) > 0) {
                choice[n++] = "x4";
            }
            if ((this.subSamplingSupp & 0xC0) > 0) {
                choice[n++] = "x5";
            }
            if ((this.subSamplingSupp & 0x300) > 0) {
                choice[n++] = "x6";
            }
            if ((this.subSamplingSupp & 0xC00) > 0) {
                choice[n++] = "x8";
            }
            if ((this.subSamplingSupp & 0x3000) > 0) {
                choice[n++] = "x16";
            }
            gd.addChoice("subSampling Mode", choice, choice[0]);
        }
        if (syncTest = IJ_IDS_Cam.isPresent("listenCOM")) {
            gd.addCheckbox("Activate COM Interface", this.syncSupp);
            gd.addNumericField("COM port", (double)this.comPort, 0);
        } else {
            this.syncSupp = false;
        }
        UIManager.LookAndFeelInfo[] plaf = UIManager.getInstalledLookAndFeels();
        String[] LaF = new String[plaf.length];
        for (int i = 0; i < plaf.length; ++i) {
            LaF[i] = plaf[i].getName();
        }
        gd.addChoice("Look and Feel", LaF, this.LOOKANDFEEL);
        gd.addCheckbox("Debug mode", this.debug);
        gd.addMessage(this.sCop);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 0;
        }
        double newcalib = gd.getNextNumber();
        this.unit = gd.getNextString();
        if (this.calib != newcalib) {
            this.calibChanged = true;
            this.calib = newcalib;
        }
        this.autoGain = gd.getNextBoolean();
        if (this.color) {
            this.autoWB = gd.getNextBoolean();
        }
        this.expFPS = (int)gd.getNextNumber();
        String choice2 = gd.getNextChoice();
        if (choice2.equals("Mono 8 bits")) {
            this.setCM = b_LUT ? 6 : 11;
            this.bitspixel = 8;
            this.stCM = "8-bit Black";
        }
        if (choice2.equals("Mono 10 bits")) {
            this.setCM = b_LUT ? 34 : 33;
            this.bitspixel = 10;
            this.stCM = "16-bit Black";
        }
        if (choice2.equals("Mono 12 bits")) {
            this.setCM = b_LUT ? 26 : 27;
            this.bitspixel = 12;
            this.stCM = "16-bit Black";
        }
        if (choice2.equals("Mono 16 bits")) {
            this.setCM = b_LUT ? 28 : 29;
            this.bitspixel = 16;
            this.stCM = "16-bit Black";
        }
        if (choice2.equals("RGB 8 bits")) {
            this.setCM = 0;
            this.bitspixel = 32;
            this.stCM = "RGB Black";
        }
        if (this.binningSupp > 0) {
            choice2 = gd.getNextChoice();
            if (choice2.equals("x16")) {
                this.setBinning = 12288;
                this.setDiv = 16;
            }
            if (choice2.equals("x8")) {
                this.setBinning = 3072;
                this.setDiv = 8;
            }
            if (choice2.equals("x6")) {
                this.setBinning = 768;
                this.setDiv = 6;
            }
            if (choice2.equals("x5")) {
                this.setBinning = 192;
                this.setDiv = 5;
            }
            if (choice2.equals("x4")) {
                this.Display("INFO - Choice Binning x4");
                this.setBinning = 12;
                this.setDiv = 4;
            }
            if (choice2.equals("x3")) {
                this.setBinning = 48;
                this.setDiv = 3;
            }
            if (choice2.equals("x2")) {
                this.setBinning = 3;
                this.setDiv = 2;
            }
        }
        if (this.subSamplingSupp > 0) {
            choice2 = gd.getNextChoice();
            if (choice2.equals("x16")) {
                this.setsubSampling = 12288;
                this.setDiv *= 16;
            }
            if (choice2.equals("x8")) {
                this.setsubSampling = 3072;
                this.setDiv *= 8;
            }
            if (choice2.equals("x6")) {
                this.setsubSampling = 768;
                this.setDiv *= 6;
            }
            if (choice2.equals("x5")) {
                this.setsubSampling = 192;
                this.setDiv *= 5;
            }
            if (choice2.equals("x4")) {
                this.Display("INFO - Choice Binning x4");
                this.setsubSampling = 12;
                this.setDiv *= 4;
            }
            if (choice2.equals("x3")) {
                this.setsubSampling = 48;
                this.setDiv *= 3;
            }
            if (choice2.equals("x2")) {
                this.setsubSampling = 3;
                this.setDiv *= 2;
            }
        }
        if (syncTest) {
            this.syncSupp = gd.getNextBoolean();
            this.comPort = (int)gd.getNextNumber();
        }
        this.LOOKANDFEEL = gd.getNextChoice();
        this.debug = gd.getNextBoolean();
        return 1;
    }

    public static int getInt(byte[] arr, int off) {
        return arr[off + 3] << 24 & 0xFF000000 | arr[off + 2] << 16 & 0xFF0000 | arr[off + 1] << 8 & 0xFF00 | arr[off] & 0xFF;
    }

    public static int getShort(byte[] arr, int off) {
        return arr[off] << 8 & 0xFF00 | arr[off + 1] & 0xFF;
    }

    void InttoByteArray(byte[] Bytes, int offset, int value) {
        Bytes[offset + 3] = (byte)(value >> 24);
        Bytes[offset + 2] = (byte)(value >> 16);
        Bytes[offset + 1] = (byte)(value >> 8);
        Bytes[offset + 0] = (byte)value;
    }

    CAMLIST GetCameraList(int NumCam) {
        CAMLIST cl = new CAMLIST();
        int sizeCAMINFO = 112;
        byte[] camlist = new byte[4 + sizeCAMINFO * NumCam];
        camlist[0] = (byte)NumCam;
        int ret = this.ueye.is_GetCameraList(camlist);
        if (ret != 0) {
            this.Display("ERROR - is_GetCameraList");
            return null;
        }
        if (NumCam != IJ_IDS_Cam.getInt(camlist, 0)) {
            this.Display("Warning - Numcam doesn't match !!!");
        }
        for (int i = 0; i < NumCam; ++i) {
            int camid = IJ_IDS_Cam.getInt(camlist, i * sizeCAMINFO + 4);
            if (this.debug) {
                this.Display("\tcamID :" + camid);
            }
            int devid = IJ_IDS_Cam.getInt(camlist, i * sizeCAMINFO + 8);
            if (this.debug) {
                this.Display("\tdevID :" + devid);
            }
            int sensorid = IJ_IDS_Cam.getInt(camlist, i * sizeCAMINFO + 12);
            if (this.debug) {
                this.Display("\tsensorID :" + sensorid);
            }
            int inUse = IJ_IDS_Cam.getInt(camlist, i * sizeCAMINFO + 16);
            if (this.debug) {
                this.Display("\tinUse :" + inUse);
            }
            try {
                String serial = new String(Arrays.copyOfRange(camlist, i * sizeCAMINFO + 20, i * sizeCAMINFO + 35), "utf8");
                if (this.debug) {
                    this.Display("\tSerNo :" + serial);
                }
                String model = new String(Arrays.copyOfRange(camlist, i * sizeCAMINFO + 36, i * sizeCAMINFO + 51), "utf8");
                if (this.debug) {
                    this.Display("\tModel :" + model);
                }
                cl.add(camid, devid, sensorid, inUse == 1, serial, model);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return cl;
    }

    boolean Init() {
        boolean error = false;
        try {
            this.ueye = (UEYE)Native.loadLibrary((String)"ueye_api_64", UEYE.class);
        }
        catch (Throwable t) {
            error = true;
        }
        if (error) {
            error = false;
            try {
                this.ueye = (UEYE)Native.loadLibrary((String)"ueye_api", UEYE.class);
            }
            catch (Throwable t) {
                error = true;
            }
        }
        if (error) {
            this.Display("Library libueye_api not found");
            return false;
        }
        this.enable.setValue(1.0);
        this.disable.setValue(0.0);
        int ver = this.ueye.is_GetDLLVersion();
        boolean bDllVersion = false;
        int nDllMajor = ver >> 24;
        int nDllMinor = ver >> 16 & 0xFF;
        int build = ver & 0xFFFF;
        if (nDllMajor > DLL_VER_MAJOR) {
            bDllVersion = true;
        } else if (nDllMajor == DLL_VER_MAJOR && nDllMinor >= DLL_VER_MINOR) {
            bDllVersion = true;
        }
        this.st = "--- START ---";
        if (this.console) {
            this.Display(this.st);
        } else {
            IJ.log((String)this.st);
        }
        this.Display("libueye_API version " + nDllMajor + "." + nDllMinor + "." + build);
        if (!bDllVersion) {
            this.Display("WARNING : this version doesn't work with libueye_api < " + DLL_VER_MAJOR + "." + DLL_VER_MINOR + "!");
            return false;
        }
        IntByReference pNumCam = new IntByReference();
        int ret = this.ueye.is_GetNumberOfCameras(pNumCam);
        if (0 == ret) {
            this.NumCam = pNumCam.getValue();
            if (this.NumCam > 0) {
                this.st = "Found " + this.NumCam + " IDS cam...";
            } else {
                this.st = "No IDS cam found";
                bDllVersion = false;
            }
            this.Display(this.st);
        } else {
            pNumCam.setValue(0);
            this.st = "Error on Cam detection";
            this.Display(this.st);
            bDllVersion = false;
        }
        int IDcam = 0;
        this.pHIDS = new IntByReference();
        if (bDllVersion && this.NumCam > (this.ListCam ? 1 : 0)) {
            GenericDialog gd = new GenericDialog(this.sVer);
            gd.setInsets(0, 75, 0);
            gd.addMessage("[Model]              [serial number]        [state]");
            String[] choice0 = new String[this.NumCam];
            CAMLIST cl = this.GetCameraList(this.NumCam);
            for (int i = 0; i < this.NumCam; ++i) {
                choice0[i] = cl.getString(i);
            }
            gd.addChoice("ID cam", choice0, choice0[0]);
            gd.addCheckbox("Do not show if only one camera exist", this.ListCam);
            gd.addMessage(this.sCop);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            IDcam = gd.getNextChoiceIndex();
            if (this.debug) {
                this.Display("DevID   : " + cl.getDevID(IDcam));
            }
            if (this.debug) {
                this.Display("Call ID : " + (cl.getDevID(IDcam) | 0x8000));
            }
            this.pHIDS.setValue(cl.getDevID(IDcam) | 0x8000);
            this.ListCam = gd.getNextBoolean();
        }
        if (this.NumCam < 1) {
            return false;
        }
        if (bDllVersion) {
            ret = this.ueye.is_InitCamera(this.pHIDS, Pointer.NULL);
            if (0 != ret) {
                this.st = "Error initializing IDS cam!";
                bDllVersion = false;
            } else {
                this.st = "IDS Cam initialisation successfull!";
            }
            this.Display(this.st);
        }
        if (bDllVersion) {
            UEYE.SENSORINFO.ByReference sensinfo = new UEYE.SENSORINFO.ByReference();
            ret = this.ueye.is_GetSensorInfo(this.pHIDS.getValue(), sensinfo);
            if (ret != 0) {
                this.Display("ERROR - IS_GetSensor");
            } else {
                this.Display("INFO - SensorID : " + sensinfo.SensorID);
                try {
                    this.ModelName = new String(sensinfo.strSensorName, "UTF8");
                    this.Display("   Model :" + this.ModelName);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                if (this.debug) {
                    this.Display("   ColorMode :" + sensinfo.nColorMode);
                }
                boolean bl = this.color = sensinfo.nColorMode > 1;
                if (this.color) {
                    this.Display("   Color Model");
                } else {
                    this.Display("   Monochrome Model");
                }
                this.Display("   Max Width  : " + sensinfo.nMaxWidth);
                this.MaxWidth = sensinfo.nMaxWidth;
                this.Display("   Max Height : " + sensinfo.nMaxHeight);
                this.MaxHeight = sensinfo.nMaxHeight;
                this.Display("   Pixel size : " + (double)sensinfo.wPixelSize / 100.0 + "um");
                if (sensinfo.bGlobShutter) {
                    this.Display("INFO - Global Shutter supported");
                } else {
                    this.Display("INFO - Global Shutter not supported");
                }
            }
        }
        if (bDllVersion) {
            ret = this.ueye.is_GetBusSpeed(this.pHIDS.getValue());
            switch (ret) {
                case 1: {
                    this.st = "ERROR - Connected to a USB1 controller!";
                    bDllVersion = false;
                    break;
                }
                case 2: {
                    this.st = "ERROR - Connected to a USB1 controller!";
                    bDllVersion = false;
                    break;
                }
                case 4: {
                    this.st = "INFO - Connected to a USB2 controller";
                    this.usb = 2;
                    break;
                }
                case 8: {
                    this.st = "INFO - Connected to a USB3 controller";
                    this.usb = 3;
                    break;
                }
                default: {
                    this.st = "Error - GetBusSpeed!";
                }
            }
            this.Display(this.st);
        }
        if (!bDllVersion) {
            return false;
        }
        IntByReference pAOIsupp = new IntByReference();
        ret = this.ueye.is_ImageFormat(this.pHIDS.getValue(), 4, pAOIsupp.getPointer(), 4);
        if (0 != ret) {
            this.st = "ERROR - ISImageFormat!";
        } else {
            this.AOIsupp = pAOIsupp.getValue() != 0;
            this.st = this.AOIsupp ? "INFO - AOI supported" : "INFO - AOI not supported";
        }
        this.Display(this.st);
        if (this.AOIsupp) {
            IntByReference pmultiAOIsupp = new IntByReference();
            ret = this.ueye.is_AOI(this.pHIDS.getValue(), 1027, pmultiAOIsupp.getPointer(), 4);
            if (0 != ret) {
                this.Display("ERROR - Multi_AOI !");
            } else if (pmultiAOIsupp.getValue() > 1) {
                this.Display("INFO - Multi_AOI supported");
                this.Display("Multi_AOI : Max nb = " + pmultiAOIsupp.getValue());
            }
        }
        this.binningSupp = this.ueye.is_SetBinning(this.pHIDS.getValue(), 32769);
        if (this.binningSupp == 0) {
            this.st = "No binning mode supported";
        } else {
            this.st = "INFO - binning Mode ";
            if ((this.binningSupp & 3) > 0) {
                ++this.Nbinning;
                this.st = this.st + "x2 ";
            }
            if ((this.binningSupp & 0x30) > 0) {
                ++this.Nbinning;
                this.st = this.st + "x3 ";
            }
            if ((this.binningSupp & 0xC) > 0) {
                ++this.Nbinning;
                this.st = this.st + "x4 ";
            }
            if ((this.binningSupp & 0xC0) > 0) {
                ++this.Nbinning;
                this.st = this.st + "x5 ";
            }
            if ((this.binningSupp & 0x300) > 0) {
                ++this.Nbinning;
                this.st = this.st + "x6 ";
            }
            if ((this.binningSupp & 0xC00) > 0) {
                ++this.Nbinning;
                this.st = this.st + "x8 ";
            }
            if ((this.binningSupp & 0x3000) > 0) {
                ++this.Nbinning;
                this.st = this.st + "x16 ";
            }
            this.st = this.st + "supported ";
        }
        this.Display(this.st);
        this.subSamplingSupp = this.ueye.is_SetSubSampling(this.pHIDS.getValue(), 32769);
        if (this.subSamplingSupp == 0) {
            this.st = "No subSampling mode supported";
        } else {
            this.st = "INFO - subSampling Mode ";
            if ((this.subSamplingSupp & 3) > 0) {
                ++this.NsubSampling;
                this.st = this.st + "x2 ";
            }
            if ((this.subSamplingSupp & 0x30) > 0) {
                ++this.NsubSampling;
                this.st = this.st + "x3 ";
            }
            if ((this.subSamplingSupp & 0xC) > 0) {
                ++this.NsubSampling;
                this.st = this.st + "x4 ";
            }
            if ((this.subSamplingSupp & 0xC0) > 0) {
                ++this.NsubSampling;
                this.st = this.st + "x5 ";
            }
            if ((this.subSamplingSupp & 0x300) > 0) {
                ++this.NsubSampling;
                this.st = this.st + "x6 ";
            }
            if ((this.subSamplingSupp & 0xC00) > 0) {
                ++this.NsubSampling;
                this.st = this.st + "x8 ";
            }
            if ((this.subSamplingSupp & 0x3000) > 0) {
                ++this.NsubSampling;
                this.st = this.st + "x16 ";
            }
            this.st = this.st + "supported ";
        }
        this.Display(this.st);
        if (1 == this.ueye.is_SetGainBoost(this.pHIDS.getValue(), 2)) {
            this.boostGainSupp = true;
            this.Display("INFO - Gain Boost supported");
        } else {
            this.Display("INFO - Gain Boost not supported");
        }
        return true;
    }

    boolean setAutoGain(boolean auto, int value) {
        DoubleByReference pval = new DoubleByReference();
        int ret = this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34817, pval, this.disable);
        if (auto) {
            if (pval.getValue() == 0.0) {
                ret = this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34816, this.enable, this.disable);
                this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34824, this.enable, this.disable);
                return ret == 0;
            }
        } else {
            if (pval.getValue() == 1.0) {
                ret = this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34816, this.disable, this.disable);
                this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34824, this.disable, this.disable);
                if (ret != 0) {
                    return false;
                }
                this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32772, value);
                return true;
            }
            this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32772, value);
        }
        return true;
    }

    boolean setAutoShutter(boolean auto, int value) {
        if (auto) {
            int ret = this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34818, this.enable, this.disable);
            this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34832, this.enable, this.disable);
            return ret == 0;
        }
        int ret = this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34818, this.disable, this.disable);
        this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34818, this.disable, this.disable);
        if (ret != 0) {
            return false;
        }
        DoubleByReference exp = new DoubleByReference();
        exp.setValue(1.0 * (double)value / 1000.0);
        this.ueye.is_Exposure(this.pHIDS.getValue(), 12, exp.getPointer(), 8);
        return true;
    }

    int set_AOI_Rect(int nCommand, UEYE.RECT rect) {
        Memory ptr = new Memory(16L);
        ptr.setInt(0L, rect.x);
        ptr.setInt(4L, rect.y);
        ptr.setInt(8L, rect.cx);
        ptr.setInt(12L, rect.cy);
        int ret = this.ueye.is_AOI(this.pHIDS.getValue(), nCommand, (Pointer)ptr, 16);
        return ret;
    }

    int set_AOI_Size(int nCommand, UEYE.IS_SIZE2D coord) {
        Memory ptr = new Memory(8L);
        ptr.setInt(0L, coord.Width);
        ptr.setInt(4L, coord.Height);
        int ret = this.ueye.is_AOI(this.pHIDS.getValue(), nCommand, (Pointer)ptr, 8);
        return ret;
    }

    int get_AOI_Size(int nCommand, UEYE.IS_SIZE2D coord) {
        Memory ptr = new Memory(8L);
        int ret = this.ueye.is_AOI(this.pHIDS.getValue(), nCommand, (Pointer)ptr, 8);
        coord.Width = ptr.getInt(0L);
        coord.Height = ptr.getInt(4L);
        return ret;
    }

    private static long getMemoryFree() {
        return Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    private void startRecording(int keyCode) {
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.isArea() && (this.AOI_rect.x != 0 || this.AOI_rect.y != 0)) {
            this.imp.deleteRoi();
            roi = null;
        }
        ImagePlus nimp = this.imp.duplicate();
        ImageProcessor nip = nimp.getProcessor();
        nip.setRoi(this.AOI_rect.x, this.AOI_rect.y, this.AOI_rect.cx, this.AOI_rect.cy);
        nimp.setProcessor(null, nip.crop());
        switch (keyCode) {
            case 77: {
                if (this.nImage == 0) {
                    nimp.setTitle("Multi-snap");
                } else {
                    nimp.setTitle("IDS_dup" + this.nImage);
                }
                nimp.copyScale(this.imp);
                nimp.show();
                if (this.nImage > 0) {
                    IJ.run((String)"Concatenate...", (String)("  title=[Multi-snap] image1=Multi-snap image2=IDS_dup" + this.nImage));
                }
                ++this.nImage;
                break;
            }
            case 83: {
                nimp.setTitle("IDS_dup");
                nimp.copyScale(this.imp);
                nimp.show();
                break;
            }
            case 82: 
            case 86: {
                if (!this.bsav) {
                    long FreeMem = IJ_IDS_Cam.getMemoryFree();
                    long reserve = 100000000L;
                    IJ.log((String)("Size of free memory: " + FreeMem / 1000000L + " MB"));
                    this.MaxImage = (FreeMem - reserve) / (long)(this.AOI_rect.cx * this.AOI_rect.cy * this.uBytesPerPixel);
                    if (roi != null && roi.isArea() && this.AOI_rect.x == 0 && this.AOI_rect.y == 0) {
                        Rectangle rect = roi.getBounds();
                        this.Display("INFO - Selection : " + rect.height + " - " + rect.width);
                        this.MaxImage = (FreeMem - reserve) / (long)(rect.height * rect.width * this.uBytesPerPixel);
                    }
                    if (keyCode == 82) {
                        final JDialog dialog2 = new JDialog();
                        JPanel centerPanel = new JPanel(new BorderLayout());
                        JPanel sliderPanel = new JPanel();
                        sliderPanel.setLayout(new GridLayout(0, 2));
                        this.lb_image = new JTextField(4);
                        this.sl_image = this.addSlider(sliderPanel, "Images (nb) : ", this.lb_image, 1, (int)this.MaxImage, (int)this.MaxImage);
                        this.lb_time = new JTextField(4);
                        this.sl_time = this.addSlider(sliderPanel, "time (in sec) : ", this.lb_time, 1, (int)((double)this.MaxImage / this.dblFPS.getValue()), (int)((double)this.MaxImage / this.dblFPS.getValue()));
                        centerPanel.add((Component)sliderPanel, "Center");
                        JPanel buttonPane = new JPanel();
                        buttonPane.setLayout(new FlowLayout(1));
                        JButton okButton = new JButton("Do it");
                        okButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                IJ_IDS_Cam.this.MaxImage = IJ_IDS_Cam.this.sl_image.getValue();
                                dialog2.dispose();
                            }
                        });
                        buttonPane.add(okButton);
                        dialog2.getRootPane().setDefaultButton(okButton);
                        JButton cancelButton = new JButton("Cancel");
                        cancelButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                dialog2.dispose();
                            }
                        });
                        buttonPane.add(cancelButton);
                        centerPanel.add((Component)buttonPane, "South");
                        dialog2.add((Component)centerPanel, "Center");
                        JStatusBar statusBar = new JStatusBar();
                        statusBar.setLeftComponent(new JLabel(this.sCop));
                        dialog2.add((Component)statusBar, "South");
                        this.MaxImage = 0L;
                        dialog2.pack();
                        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                        dialog2.setLocation(screen.width / 2 - 400, (screen.height - 200) / 2);
                        dialog2.setSize(400, 200);
                        dialog2.setTitle("Recording");
                        dialog2.setModal(true);
                        dialog2.setVisible(true);
                    }
                    if (this.MaxImage == 0L) break;
                    IJ.log((String)("Nb of image to save: " + this.MaxImage));
                    IJ.log((String)("duration of recording: " + IJ.d2s((double)((double)this.MaxImage / this.dblFPS.getValue()), (int)2) + " sec"));
                    if (this.MaxImage > 0L) {
                        this.end = false;
                        IJ.log((String)"Recording video in memory ...");
                        this.ist = nimp.createEmptyStack();
                        this.sb_left.setText("Recording " + this.MaxImage + " images");
                        this.bsav = true;
                        this.StartTime = System.nanoTime() / 1000L;
                        break;
                    }
                    IJ.log((String)"Not enougth memory ... disabling recording.");
                    break;
                }
                if (this.cbi_rts == 3) {
                    this.sync.sendRTS(true);
                }
                this.bsav = false;
                long EndTime = System.nanoTime() / 1000L;
                this.sb_left.setText("Acquiring at " + this.getSpeed());
                nimp.setStack(this.ist);
                nimp.copyScale(this.imp);
                nimp.setTitle("video" + this.nVideo);
                ++this.nVideo;
                nimp.show();
                long first = Long.parseLong(nimp.getStack().getSliceLabel(1));
                long last = Long.parseLong(nimp.getStack().getSliceLabel(nimp.getStackSize()));
                long laps = last - first;
                IJ.log((String)"Stop recording, opening frames...");
                IJ.log((String)("Frame interval: " + IJ.d2s((double)(1000.0 / this.dblFPS.getValue()), (int)2) + " ms"));
                IJ.log((String)("Time laps: " + IJ.d2s((double)((double)laps / 1000000.0), (int)3) + " sec"));
                double fic = 0.0;
                if (nimp.getStackSize() > 1) {
                    fic = 0.001 * (double)laps / (double)(nimp.getStackSize() - 1);
                }
                IJ.log((String)("Real Video Frequency Acquisition: " + IJ.d2s((double)(1000.0 / fic), (int)1) + " Hz"));
                IJ.log((String)("Corrected Frame interval: " + IJ.d2s((double)fic, (int)2) + " ms"));
                Calibration cal = nimp.getCalibration();
                cal.setTimeUnit("msec");
                cal.frameInterval = this.dblFPS.getValue() != 0.0 ? fic : 0.0;
                this.MaxImage = -1L;
            }
        }
    }

    public void run(String s) {
        this.loadDefaultValues();
        this.Active = this.Init();
        if (!this.Active) {
            return;
        }
        if (this.showInitDialog() == 0) {
            this.Close();
            return;
        }
        this.initLookAndFeel();
        JFrame.setDefaultLookAndFeelDecorated(true);
        int ret = this.ueye.is_SetDisplayMode(this.pHIDS.getValue(), 2049);
        this.st = 0 != ret ? "Error initializing DisplayMode!" : "Set DisplayMode (DIB) successfull!";
        this.Display(this.st);
        this.ueye.is_SetBinning(this.pHIDS.getValue(), this.setBinning);
        this.binningMode = this.ueye.is_SetBinning(this.pHIDS.getValue(), 32768);
        this.Display("INFO - Binning Set : " + this.binningMode);
        if (this.binningMode == this.setBinning) {
            this.vDiv = this.hDiv = this.setDiv;
        } else {
            this.Display("ERROR - Binning Mode " + this.binningMode);
        }
        this.ueye.is_SetSubSampling(this.pHIDS.getValue(), this.setsubSampling);
        this.subSamplingMode = this.ueye.is_SetSubSampling(this.pHIDS.getValue(), 32768);
        this.Display("INFO - subSampling Set : " + this.subSamplingMode);
        if (this.subSamplingMode == this.setsubSampling) {
            this.vDiv = this.hDiv = this.setDiv;
        } else {
            this.Display("ERROR - subSampling Mode " + this.subSamplingMode);
        }
        ret = this.ueye.is_SetColorMode(this.pHIDS.getValue(), this.setCM);
        if (ret != 0) {
            this.st = "ERROR (BACK TO MONO_8)";
            this.setCM = 6;
            this.bitspixel = 8;
            this.ueye.is_SetColorMode(this.pHIDS.getValue(), this.setCM);
            this.stCM = "8-bit Black";
        } else {
            this.st = "SUCCES";
        }
        this.Display(this.st + " - IS_SetColorMode");
        this.ImgSize = new UEYE.IS_SIZE2D();
        this.ImgSize.Width = this.MaxWidth / this.hDiv;
        this.ImgSize.Height = this.MaxHeight / this.vDiv;
        this.uBytesPerPixel = (this.bitspixel + 7) / 8;
        this.uImageSize = this.ImgSize.Width * this.ImgSize.Height;
        int decalDisplay = 0;
        this.imp = IJ.createImage((String)"IDS Cam", (String)this.stCM, (int)this.ImgSize.Width, (int)(this.ImgSize.Height + decalDisplay), (int)1);
        this.ip = this.imp.getProcessor();
        this.ist = this.imp.createEmptyStack();
        Calibration cal = this.imp.getCalibration();
        cal.setUnit(this.unit);
        cal.pixelWidth = this.calib * (double)this.setDiv;
        cal.pixelHeight = this.calib * (double)this.setDiv;
        switch (this.uBytesPerPixel) {
            case 4: {
                this.pix32 = (int[])this.ip.getPixels();
                break;
            }
            case 2: {
                this.pix16 = (short[])this.ip.getPixels();
                break;
            }
            case 1: {
                this.pix8 = (byte[])this.ip.getPixels();
            }
        }
        this.ppcImgMem = new PointerByReference();
        this.pid = new IntByReference();
        ret = this.ueye.is_AllocImageMem(this.pHIDS.getValue(), this.ImgSize.Width, this.ImgSize.Height, this.bitspixel, this.ppcImgMem, this.pid);
        this.Display("INFO - BPP : " + this.bitspixel);
        this.Display("INFO - Memory size : " + this.uImageSize);
        if (ret != 0) {
            this.Display("ERROR - IS_allocMem");
        } else {
            this.Display("SUCCESS - pid : " + this.pid.getValue());
            this.Display("SUCCESS - ppcImgMem : " + this.ppcImgMem.getValue());
        }
        ret = this.ueye.is_SetImageMem(this.pHIDS.getValue(), this.ppcImgMem.getValue(), this.pid.getValue());
        this.st = ret != 0 ? "ERROR" : "SUCCES";
        this.Display(this.st + " - IS_SetImageMem");
        this.Display("INFO - Width : " + this.ImgSize.Width);
        this.Display("INFO - Height : " + this.ImgSize.Height);
        this.Display("Structure Size : " + this.ImgSize.size());
        ret = this.set_AOI_Size(5, this.ImgSize);
        this.st = ret != 0 ? "ERROR (" + ret + ")" : "SUCCES";
        this.Display(this.st + " - IS_AOI");
        Memory range = new Memory(12L);
        ret = this.ueye.is_PixelClock(this.pHIDS.getValue(), 3, (Pointer)range, 12);
        this.st = ret != 0 ? "ERROR" : "SUCCES";
        this.Display(this.st + " - IS_PixelClock");
        if (ret == 0) {
            this.st = "INFO - " + range.getInt(0L) + " " + range.getInt(4L) + " " + range.getInt(8L) + " ";
            this.Display(this.st);
        }
        this.maxClock = range.getInt(4L);
        this.minClock = range.getInt(0L);
        this.incClock = range.getInt(8L);
        this.nbInc = 0;
        if (this.incClock != 0) {
            this.nbInc = (this.maxClock - this.minClock) / this.incClock;
        } else {
            IntByReference inc = new IntByReference();
            this.ueye.is_PixelClock(this.pHIDS.getValue(), 1, inc.getPointer(), 4);
            this.nbInc = inc.getValue();
        }
        if (this.incClock != 0) {
            IntByReference newClock = new IntByReference();
            newClock.setValue(this.minClock + this.incClock * this.nbInc / 4);
            ret = this.ueye.is_PixelClock(this.pHIDS.getValue(), 6, newClock.getPointer(), 4);
            this.st = ret != 0 ? "ERROR" : "SUCCES";
            this.Display(this.st + " - IS_SetpixelClock");
        } else {
            this.arrayClock = new Memory((long)(this.nbInc * 4));
            ret = this.ueye.is_PixelClock(this.pHIDS.getValue(), 2, this.arrayClock, this.nbInc * 4);
            this.st = ret != 0 ? "ERROR" : "SUCCES";
            this.Display(this.st + " - IS_SetpixelClock - set Array Clock ");
        }
        DoubleByReference enable = new DoubleByReference();
        enable.setValue(1.0);
        DoubleByReference disable = new DoubleByReference();
        disable.setValue(0.0);
        this.st = this.setAutoGain(this.autoGain, this.gain) ? "SUCCES" : "ERROR";
        this.Display(this.st + " - IS_SetAuto Gain On");
        if (this.autoWB) {
            ret = this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34820, enable, disable);
            this.st = ret != 0 ? "ERROR" : "SUCCES";
            this.Display(this.st + " - IS_SetAuto WB On");
            ret = this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34838, enable, disable);
        }
        this.st = (ret = this.ueye.is_SetAutoParameter(this.pHIDS.getValue(), 34822, disable, disable)) != 0 ? "ERROR" : "SUCCES";
        this.Display(this.st + " - IS_SetAuto FrameRate Off");
        if (this.autoShutter) {
            this.st = this.setAutoShutter(this.autoShutter, 0) ? "SUCCES" : "ERROR";
            this.Display(this.st + " - IS_SetAuto Shutter On");
        }
        if ((ret = this.ueye.is_CaptureVideo(this.pHIDS.getValue(), 1)) != 0) {
            this.Display("ERROR - IS_Capture");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        ret = this.ueye.is_GetFramesPerSecond(this.pHIDS.getValue(), this.dblFPS);
        if (ret != 0) {
            this.Display("ERROR - IS_getFR");
        } else {
            this.Display("SUCCESS - FrameRate : " + this.dblFPS.getValue());
        }
        this.pcImgMem = this.ppcImgMem.getValue();
        this.imp.show();
        boolean fr = false;
        if (this.AOIsupp) {
            this.AOI_pos_min = new UEYE.IS_SIZE2D();
            this.AOI_pos_inc = new UEYE.IS_SIZE2D();
            this.AOI_size_inc = new UEYE.IS_SIZE2D();
            this.AOI_size_min = new UEYE.IS_SIZE2D();
            ret = this.get_AOI_Size(7, this.AOI_pos_min);
            if (ret != 0) {
                this.Display("ERROR - IS_AOI");
            } else {
                this.Display("INFO AOI_pos_min : (" + this.AOI_pos_min.Width + "," + this.AOI_pos_min.Height + ")");
            }
            ret = this.get_AOI_Size(8, this.AOI_size_min);
            if (ret != 0) {
                this.Display("ERROR - IS_AOI");
            } else {
                this.Display("INFO AOI_size_min : (" + this.AOI_size_min.Width + "," + this.AOI_size_min.Height + ")");
            }
            ret = this.get_AOI_Size(17, this.AOI_pos_inc);
            if (ret != 0) {
                this.Display("ERROR - IS_AOI");
            } else {
                this.Display("INFO AOI_pos_inc : (" + this.AOI_pos_inc.Width + "," + this.AOI_pos_inc.Height + ")");
            }
            ret = this.get_AOI_Size(18, this.AOI_size_inc);
            if (ret != 0) {
                this.Display("ERROR - IS_AOI");
            } else {
                this.Display("INFO AOI_size_inc : (" + this.AOI_size_inc.Width + "," + this.AOI_size_inc.Height + ")");
            }
        }
        this.AOI_rect = new UEYE.RECT.ByReference();
        this.AOI_rect.x = 0;
        this.AOI_rect.y = 0;
        this.AOI_rect.cx = this.ImgSize.Width;
        this.AOI_rect.cy = this.ImgSize.Height;
        DoubleByReference pFPS = new DoubleByReference();
        ret = this.ueye.is_SetFrameRate(this.pHIDS.getValue(), this.expFPS, pFPS);
        this.Display("INFO - wanted FrameRate : " + this.expFPS + "(" + pFPS.getValue() + ")");
        boolean error = false;
        this.showControlDialog();
        int rdFPS = 0;
        if (this.bitspixel == 10) {
            this.ip.setMinAndMax(1.0, 1023.0);
        }
        if (this.bitspixel == 12) {
            this.ip.setMinAndMax(1.0, 4095.0);
        }
        this.win = this.imp.getWindow();
        this.canvas = this.win.getCanvas();
        this.win.removeKeyListener((KeyListener)IJ.getInstance());
        this.canvas.removeKeyListener((KeyListener)IJ.getInstance());
        this.win.addKeyListener((KeyListener)this);
        this.canvas.addKeyListener((KeyListener)this);
        ImagePlus.addImageListener((ImageListener)this);
        this.sync = null;
        if (this.syncSupp) {
            if (this.debug) {
                this.Display("COM interface (GetSync.jar) found");
            }
            this.sync = new listenCOM();
            this.sync.setPort(this.comPort);
            this.sync.setPriority(10);
            this.sync.start();
            if (!this.sync.isStarted(3000)) {
                this.Display("Warning : Cannot initialize COM port");
                IJ.showMessage((String)"Warning", (String)"Cannot initialize COM port!!!");
                this.sync.interrupt();
                this.sync = null;
                this.syncSupp = false;
            }
        }
        if (this.syncSupp) {
            this.sync.sendRTS(true);
            this.sync.sendDTR(false);
        }
        long synchroWait = 0L;
        long synchroWaitProto = 0L;
        long synchroStart = 0L;
        boolean cb_acqProto = false;
        this.hEvent = new WinNT.HANDLE();
        if (IJ_IDS_Cam.isWindows()) {
            this.hEvent = Kernel32.INSTANCE.CreateEvent(null, false, false, null);
            this.ueye.is_InitEvent(this.pHIDS.getValue(), this.hEvent, 0);
        }
        this.ueye.is_EnableEvent(this.pHIDS.getValue(), 0);
        String meta = "";
        IntByReference LED = new IntByReference();
        boolean LEDblk = true;
        LED.setValue(2);
        this.ueye.is_IO(this.pHIDS.getValue(), 9, LED.getPointer(), 4);
        while (this.Active) {
            if (IJ.getInstance() == null) {
                if (this.syncSupp) {
                    this.sync.interrupt();
                }
                this.sync = null;
                this.Close();
                break;
            }
            if (IJ_IDS_Cam.isWindows()) {
                Kernel32.INSTANCE.WaitForSingleObject(this.hEvent, 2000);
            } else {
                ret = this.ueye.is_WaitEvent(this.pHIDS.getValue(), 0, 2000);
            }
            long timeStamp = System.nanoTime() / 1000L - this.StartTime;
            if (this.syncSupp) {
                if (synchroWait > 0L && --synchroWait == 0L) {
                    LED.setValue(2);
                    this.ueye.is_IO(this.pHIDS.getValue(), 9, LED.getPointer(), 4);
                }
                if (synchroStart > 0L && --synchroStart == 0L) {
                    this.startRecording(77);
                }
                if (synchroWaitProto > 0L && --synchroWaitProto == 0L) {
                    if (cb_acqProto) {
                        this.startRecording(77);
                        cb_acqProto = false;
                        this.sync.sendDTR(cb_acqProto);
                        synchroWaitProto = (int)(this.dblFPS.getValue() * ((double)this.proto_periode - 0.5));
                    } else {
                        synchroWaitProto = (int)(this.dblFPS.getValue() * 0.5);
                        cb_acqProto = true;
                        this.sync.sendDTR(cb_acqProto);
                    }
                }
                if (this.cbi_rts == 1) {
                    this.sync.switchRTS();
                }
                if (this.cbi_led == 1) {
                    LED.setValue(LEDblk ? 3 : 2);
                    this.ueye.is_IO(this.pHIDS.getValue(), 9, LED.getPointer(), 4);
                    boolean bl = LEDblk = !LEDblk;
                }
                if (this.sync.isDSR()) {
                    if (this.cb_sync) {
                        meta = "sync ";
                    }
                    if (this.cb_syncbip) {
                        IJ.beep();
                    }
                    if (this.cbi_rts == 2) {
                        this.sync.switchRTS();
                    }
                    if (this.cbi_led == 2 && synchroWait <= 0L) {
                        LED.setValue(3);
                        this.ueye.is_IO(this.pHIDS.getValue(), 9, LED.getPointer(), 4);
                        synchroWait = (int)this.dblFPS.getValue() / 10;
                        long l = synchroWait = synchroWait < 1L ? 1L : synchroWait;
                    }
                }
                if (this.sync.isCTS()) {
                    if (this.cb_top) {
                        meta = meta + "top ";
                    }
                    if (this.cb_vidAcq) {
                        this.startRecording(86);
                    }
                    if (this.cb_snap) {
                        if (this.delay == 0) {
                            this.startRecording(77);
                        } else {
                            synchroStart = (int)(this.dblFPS.getValue() * (double)this.delay);
                        }
                    }
                    if (this.cb_beep) {
                        IJ.beep();
                    }
                }
                if (this.SPACE) {
                    meta = meta + "mark ";
                    if (synchroWaitProto > 0L) {
                        synchroWaitProto = 0L;
                        cb_acqProto = false;
                        this.sync.sendDTR(cb_acqProto);
                    } else if (this.cb_proto) {
                        synchroWaitProto = (int)(this.dblFPS.getValue() * 0.5);
                        this.Display("Open shutter " + synchroWaitProto);
                        cb_acqProto = true;
                        this.sync.sendDTR(cb_acqProto);
                    }
                    this.SPACE = false;
                }
            }
            if (null == this.imp.getWindow()) {
                if (this.syncSupp) {
                    this.sync.interrupt();
                }
                this.sync = null;
                this.Close();
                break;
            }
            switch (this.uBytesPerPixel) {
                case 4: {
                    if (this.AOI_rect.cx < this.ImgSize.Width) {
                        for (int i = 0; i < this.AOI_rect.cy; ++i) {
                            this.pcImgMem.read((long)(i * this.ImgSize.Width * this.uBytesPerPixel), this.pix32, this.AOI_rect.x + (this.AOI_rect.y + i) * this.ImgSize.Width, this.AOI_rect.cx);
                        }
                        break;
                    }
                    this.pcImgMem.read(0L, this.pix32, this.AOI_rect.y * this.ImgSize.Width, this.uImageSize);
                    break;
                }
                case 2: {
                    if (this.AOI_rect.cx < this.ImgSize.Width) {
                        for (int i = 0; i < this.AOI_rect.cy; ++i) {
                            this.pcImgMem.read((long)(i * this.ImgSize.Width * this.uBytesPerPixel), this.pix16, this.AOI_rect.x + (this.AOI_rect.y + i) * this.ImgSize.Width, this.AOI_rect.cx);
                        }
                        break;
                    }
                    this.pcImgMem.read(0L, this.pix16, this.AOI_rect.y * this.ImgSize.Width, this.uImageSize);
                    break;
                }
                case 1: {
                    if (this.AOI_rect.cx < this.ImgSize.Width) {
                        for (int i = 0; i < this.AOI_rect.cy; ++i) {
                            this.pcImgMem.read((long)(i * this.ImgSize.Width), this.pix8, this.AOI_rect.x + (this.AOI_rect.y + i) * this.ImgSize.Width, this.AOI_rect.cx);
                        }
                        break;
                    }
                    this.pcImgMem.read(0L, this.pix8, this.AOI_rect.y * this.ImgSize.Width, this.uImageSize);
                }
            }
            Prefs.set((String)"Cam.newImage", (boolean)true);
            if (this.bsav && !this.end) {
                if (this.MaxImage > 0L) {
                    --this.MaxImage;
                    meta = meta + timeStamp;
                    ImagePlus dimp = this.imp.duplicate();
                    ImageProcessor dip = dimp.getProcessor();
                    dip.setRoi(this.AOI_rect.x, this.AOI_rect.y, this.AOI_rect.cx, this.AOI_rect.cy);
                    this.ist.addSlice(meta, dip.crop());
                    meta = "";
                } else {
                    if (this.cbi_rts == 3) {
                        this.sync.sendRTS(true);
                    }
                    this.startRecording(82);
                }
            }
            if (!this.bsav || !this.bHide) {
                this.imp.updateAndDraw();
            }
            --rdFPS;
            if (--rdFPS >= 0) continue;
            ret = this.ueye.is_GetFramesPerSecond(this.pHIDS.getValue(), this.dblFPS);
            if (ret != 0) {
                this.st = "error";
            } else {
                rdFPS = (int)Math.round(this.dblFPS.getValue() / 2.0);
                this.st = String.format("%.1f fps", this.dblFPS.getValue());
            }
            this.lb_FPS.setText(this.st);
            if (this.bsav && !this.end) {
                if (this.cbi_rts == 3) {
                    this.sync.sendRTS(false);
                }
                this.sb_left.setText("Recording " + this.MaxImage + " images");
            }
            if (this.autoGain) {
                this.gain = this.ueye.is_SetHWGainFactor(this.pHIDS.getValue(), 32768, this.gain);
                this.sl_gain.setValue(this.gain);
            }
            if (!this.autoShutter) continue;
            DoubleByReference exp = new DoubleByReference();
            this.ueye.is_Exposure(this.pHIDS.getValue(), 7, exp.getPointer(), 8);
            this.sl_expTime.setValue((int)(1000.0 * exp.getValue()));
        }
        if (this.debug) {
            this.Display("DEBUG:syncsupp=" + this.syncSupp);
        }
        if (this.syncSupp) {
            this.sync.interrupt();
            this.sync = null;
        }
    }

    void loadDefaultValues() {
        this.ListCam = Prefs.get((String)"IDScam.ListCam", (boolean)this.ListCam);
        this.calib = Prefs.get((String)"IDScam.calib", (double)this.calib);
        this.unit = Prefs.get((String)"IDScam.unit", (String)this.unit);
        this.autoGain = Prefs.get((String)"IDScam.autoGain", (boolean)this.autoGain);
        this.expFPS = (int)Prefs.get((String)"IDScam.expFPS", (double)this.expFPS);
        this.LOOKANDFEEL = Prefs.get((String)"IDScam.LaF", (String)this.LOOKANDFEEL);
        this.syncSupp = Prefs.get((String)"IDScam.syncSupp", (boolean)this.syncSupp);
        this.comPort = (int)Prefs.get((String)"IDScam.comPort", (double)this.comPort);
        this.debug = Prefs.get((String)"IDScam.debug", (boolean)this.debug);
        this.Rgain = (int)Prefs.get((String)"IDScam.Rgain", (double)this.Rgain);
        this.Ggain = (int)Prefs.get((String)"IDScam.Ggain", (double)this.Ggain);
        this.Bgain = (int)Prefs.get((String)"IDScam.Bgain", (double)this.Bgain);
        this.cb_sync = Prefs.get((String)"IDScam.cb_sync", (boolean)this.cb_sync);
        this.cb_top = Prefs.get((String)"IDScam.cb_top", (boolean)this.cb_top);
        this.cb_vidAcq = Prefs.get((String)"IDScam.cb_vidAcq", (boolean)this.cb_vidAcq);
        this.cb_snap = Prefs.get((String)"IDScam.cb_snap", (boolean)this.cb_snap);
        this.cb_beep = Prefs.get((String)"IDScam.cb_beep", (boolean)this.cb_beep);
        this.cb_dtr = Prefs.get((String)"IDScam.cb_dtr", (boolean)this.cb_dtr);
        this.cbi_rts = (int)Prefs.get((String)"IDScam.cbi_rts", (double)this.cbi_rts);
        this.cbi_led = (int)Prefs.get((String)"IDScam.cbi_led", (double)this.cbi_led);
        this.cb_syncbip = Prefs.get((String)"IDScam.cb_syncbip", (boolean)this.cb_syncbip);
    }

    void saveValues() {
        Prefs.set((String)"IDScam.autoGain", (boolean)this.autoGain);
        Prefs.set((String)"IDScam.ListCam", (boolean)this.ListCam);
        Prefs.set((String)"IDScam.expFPS", (int)this.expFPS);
        Prefs.set((String)"IDScam.LaF", (String)this.LOOKANDFEEL);
        Prefs.set((String)"IDScam.syncSupp", (boolean)this.syncSupp);
        Prefs.set((String)"IDScam.comPort", (int)this.comPort);
        Prefs.set((String)"IDScam.debug", (boolean)this.debug);
        Prefs.set((String)"IDScam.Rgain", (int)this.Rgain);
        Prefs.set((String)"IDScam.Ggain", (int)this.Ggain);
        Prefs.set((String)"IDScam.Bgain", (int)this.Bgain);
        Prefs.set((String)"IDScam.cb_top", (boolean)this.cb_top);
        Prefs.set((String)"IDScam.cb_sync", (boolean)this.cb_sync);
        Prefs.set((String)"IDScam.cb_vidAcq", (boolean)this.cb_vidAcq);
        Prefs.set((String)"IDScam.cb_snap", (boolean)this.cb_snap);
        Prefs.set((String)"IDScam.cb_beep", (boolean)this.cb_beep);
        Prefs.set((String)"IDScam.cb_dtr", (boolean)this.cb_dtr);
        Prefs.set((String)"IDScam.cbi_rts", (int)this.cbi_rts);
        Prefs.set((String)"IDScam.cbi_led", (int)this.cbi_led);
        Prefs.set((String)"IDScam.cb_syncbip", (boolean)this.cb_syncbip);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        int flags = e.getModifiers();
        if (flags != 0) {
            IJ.getInstance().keyPressed(e);
        }
        switch (keyCode) {
            case 67: {
                if (this.setCM == 0) {
                    if (this.colorDiag == null) {
                        this.showColorDialog();
                    } else {
                        this.colorDiag.setVisible(true);
                    }
                }
            }
            case 69: {
                UEYE.RECT.ByReference AOI_new = new UEYE.RECT.ByReference();
                Rectangle r = this.imp.getProcessor().getRoi();
                AOI_new.x = r.x;
                AOI_new.y = r.y;
                AOI_new.cx = r.width;
                AOI_new.cy = r.height;
                int ret = this.set_AOI_Rect(48, AOI_new);
                if (ret == 0) break;
                this.Display("ERROR - IS_AOI_AUTO_BRIGHTNESS_SET_AOI");
                break;
            }
            case 32: {
                this.SPACE = true;
                break;
            }
            case 27: {
                break;
            }
            case 65: {
                Rectangle r = this.imp.getProcessor().getRoi();
                this.lb_AOIX.setText("" + r.x / this.AOI_pos_inc.Width);
                this.setSlider(this.lb_AOIX, this.sl_AOIX);
                int decal = r.x % this.AOI_pos_inc.Width;
                this.lb_AOIY.setText("" + r.y / this.AOI_pos_inc.Height);
                this.setSlider(this.lb_AOIY, this.sl_AOIY);
                this.lb_AOICX.setText("" + (r.width <= this.AOI_size_min.Width ? this.AOI_size_min.Width / this.AOI_size_inc.Width : (r.width + decal) / this.AOI_size_inc.Width));
                this.setSlider(this.lb_AOICX, this.sl_AOICX);
                this.lb_AOICY.setText("" + (r.height <= this.AOI_size_min.Height ? this.AOI_size_min.Height / this.AOI_size_inc.Height : r.height / this.AOI_size_inc.Height));
                this.setSlider(this.lb_AOICY, this.sl_AOICY);
                break;
            }
            case 90: {
                int xCenter = this.AOI_rect.x + this.AOI_rect.cx / 2;
                int yCenter = this.AOI_rect.y + this.AOI_rect.cy / 2;
                IJ.run((String)"Set... ", (String)("x=" + xCenter + " y=" + yCenter));
                break;
            }
            case 80: {
                if (this.bplay) {
                    this.ueye.is_FreezeVideo(this.pHIDS.getValue(), 1);
                    this.sb_left.setText("Paused");
                } else {
                    this.ueye.is_CaptureVideo(this.pHIDS.getValue(), 1);
                    this.sb_left.setText("Acquiring at " + this.getSpeed());
                }
                this.bplay = !this.bplay;
                break;
            }
            case 83: {
                this.startRecording(keyCode);
                break;
            }
            case 82: 
            case 86: {
                this.startRecording(keyCode);
                break;
            }
            default: {
                IJ.getInstance().keyPressed(e);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void imageOpened(ImagePlus imp) {
    }

    public void imageClosed(ImagePlus imp2) {
        if (imp2 == this.imp) {
            this.Close();
            return;
        }
    }

    public void imageUpdated(ImagePlus imp) {
    }

    void Display(String st) {
        if (this.console) {
            System.err.println(st);
        } else {
            IJ.log((String)st);
        }
    }

    void Close() {
        if (this.Active) {
            this.Active = false;
            IJ.wait((int)500);
            this.ueye.is_DisableEvent(this.pHIDS.getValue(), 0);
            if (IJ_IDS_Cam.isWindows()) {
                this.ueye.is_ExitEvent(this.pHIDS.getValue(), 0);
                Kernel32.INSTANCE.CloseHandle(this.hEvent);
            }
            if (this.imp != null) {
                Calibration cal = this.imp.getCalibration();
                if (cal.pixelWidth != this.calib * (double)this.setDiv) {
                    this.unit = cal.getUnit();
                    this.calib = cal.pixelWidth / (double)this.setDiv;
                    this.calibChanged = true;
                }
            }
            if (this.calibChanged && IJ.showMessageWithCancel((String)"Settings", (String)"Calibration changed, replace?")) {
                Prefs.set((String)"IDScam.calib", (double)this.calib);
                Prefs.set((String)"IDScam.unit", (String)this.unit);
            }
            this.saveValues();
            int ret = this.ueye.is_StopLiveVideo(this.pHIDS.getValue(), 1);
            if (ret != 0) {
                this.Display("ERROR - IS_StopLive");
            }
            if (this.ppcImgMem != null) {
                ret = this.ueye.is_FreeImageMem(this.pHIDS.getValue(), this.ppcImgMem.getValue(), this.pid.getValue());
                if (ret != 0) {
                    this.Display("ERROR - IS_FreeImageMem");
                } else {
                    this.Display("SUCCES - Free Image Memory");
                }
            }
            if ((ret = this.ueye.is_ExitCamera(this.pHIDS.getValue())) != 0) {
                this.Display("ERROR - Closing IDS Cam");
            } else {
                this.Display("SUCCES - Closing IDS Cam");
            }
        }
        if (this.colorDiag != null) {
            this.colorDiag.dispose();
        }
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        if (this.win != null) {
            this.win.removeKeyListener((KeyListener)this);
        }
        if (this.canvas != null) {
            this.canvas.removeKeyListener((KeyListener)this);
        }
    }

    public static interface UEYE
    extends Library {
        public int is_GetDLLVersion();

        public int is_GetUsedBandwidth(int var1);

        public int is_GetNumberOfCameras(IntByReference var1);

        public int is_InitCamera(IntByReference var1, Pointer var2);

        public int is_ExitCamera(int var1);

        public int is_StopLiveVideo(int var1, int var2);

        public int is_FreezeVideo(int var1, int var2);

        public int is_ImageFormat(int var1, int var2, Pointer var3, int var4);

        public int is_GetColorDepth(int var1, IntByReference var2, IntByReference var3);

        public int is_SetColorMode(int var1, int var2);

        public int is_PixelClock(int var1, int var2, Pointer var3, int var4);

        public int is_SetImageMem(int var1, Pointer var2, int var3);

        public int is_SetBinning(int var1, int var2);

        public int is_SetSubSampling(int var1, int var2);

        public int is_GetBusSpeed(int var1);

        public int is_Configuration(int var1, Pointer var2, int var3);

        public int is_SetHWGainFactor(int var1, int var2, int var3);

        public int is_SetAutoParameter(int var1, int var2, DoubleByReference var3, DoubleByReference var4);

        public int is_SetGainBoost(int var1, int var2);

        public int is_ResetToDefault(int var1);

        public int is_CaptureVideo(int var1, int var2);

        public int is_SetDisplayMode(int var1, int var2);

        public int is_SetFrameRate(int var1, double var2, DoubleByReference var4);

        public int is_Exposure(int var1, int var2, Pointer var3, int var4);

        public int is_GetFrameTimeRange(int var1, DoubleByReference var2, DoubleByReference var3, DoubleByReference var4);

        public int is_GetFramesPerSecond(int var1, DoubleByReference var2);

        public int is_SetImageSize(int var1, int var2, int var3);

        public int is_AOI(int var1, int var2, Pointer var3, int var4);

        public int is_GetSensorInfo(int var1, SENSORINFO.ByReference var2);

        public int is_GetCameraList(byte[] var1);

        public long is_CameraStatus(int var1, int var2, long var3);

        public int is_GetCameraInfo(int var1, CAMINFO.ByReference var2);

        public int is_AllocImageMem(int var1, int var2, int var3, int var4, PointerByReference var5, IntByReference var6);

        public int is_SetAllocatedImageMem(int var1, int var2, int var3, int var4, ByteByReference var5, IntByReference var6);

        public int is_FreeImageMem(int var1, Pointer var2, int var3);

        public int is_WaitForNextImage(int var1, int var2, PointerByReference var3, IntByReference var4);

        public int is_IO(int var1, int var2, Pointer var3, int var4);

        public int is_InitEvent(int var1, WinNT.HANDLE var2, int var3);

        public int is_WaitEvent(int var1, int var2, int var3);

        public int is_EnableEvent(int var1, int var2);

        public int is_DisableEvent(int var1, int var2);

        public int is_ExitEvent(int var1, int var2);

        public static class SENSORINFO
        extends Structure {
            public short SensorID;
            public byte[] strSensorName = new byte[32];
            public byte nColorMode;
            public int nMaxWidth;
            public int nMaxHeight;
            public boolean bMasterGain;
            public boolean bRGain;
            public boolean bGGain;
            public boolean bBGain;
            public boolean bGlobShutter;
            public short wPixelSize;
            public byte nUpperLeftBayerPixel;
            public byte[] Reserved = new byte[13];

            protected List getFieldOrder() {
                return Arrays.asList("SensorID", "strSensorName", "nColorMode", "nMaxWidth", "nMaxHeight", "bMasterGain", "bRGain", "bGGain", "bBGain", "bGlobShutter", "wPixelSize", "nUpperLeftBayerPixel", "Reserved");
            }

            public static class ByReference
            extends SENSORINFO
            implements Structure.ByReference {
            }
        }

        public static class CAMINFO
        extends Structure {
            public byte[] strSerNo = new byte[12];
            public byte[] strID = new byte[20];
            public byte[] strVersion = new byte[10];
            public byte[] strDate = new byte[12];
            public byte Select;
            public byte Type;
            public byte[] Reserved = new byte[8];

            protected List getFieldOrder() {
                return Arrays.asList("strSerNo", "strID", "strVersion", "strDate", "Select", "Type", "Reserved");
            }

            public static class ByReference
            extends CAMINFO
            implements Structure.ByReference {
            }
        }

        public static class RECT
        extends Structure {
            public int x;
            public int y;
            public int cx;
            public int cy;

            protected List getFieldOrder() {
                return Arrays.asList("x", "y", "cx", "cy");
            }

            public static class ByReference
            extends RECT
            implements Structure.ByReference {
            }
        }

        public static class IS_SIZE2D
        extends Structure {
            public int Width;
            public int Height;

            protected List getFieldOrder() {
                return Arrays.asList("Width", "Height");
            }

            public static class ByReference
            extends IS_SIZE2D
            implements Structure.ByReference {
            }
        }
    }

    public static class CAMLIST {
        protected CAMINFO first = null;
        protected CAMINFO last;

        public boolean isEmpty() {
            return this.first == null;
        }

        public void add(int a, int b, int c, boolean d, String s1, String s2) {
            CAMINFO p = new CAMINFO(a, b, c, d, s1, s2);
            if (this.isEmpty()) {
                this.first = p;
            } else {
                this.last.next = p;
            }
            this.last = p;
        }

        public String getString(int n) {
            CAMINFO current = this.first;
            while (n != 0) {
                if (current.next == null) {
                    return "error";
                }
                current = current.next;
                --n;
            }
            if (current != null) {
                return " " + current.Model + current.SerNo + (current.inUse ? "in use" : "ready");
            }
            return "error";
        }

        public int getDevID(int n) {
            CAMINFO current = this.first;
            while (n != 0) {
                if (current.next == null) {
                    return 0;
                }
                current = current.next;
                --n;
            }
            if (current != null) {
                return current.devID;
            }
            return 0;
        }

        public static class CAMINFO {
            public int camID;
            public int devID;
            public int sensorID;
            public boolean inUse;
            public String SerNo;
            public String Model;
            public CAMINFO next;

            CAMINFO(int a, int b, int c, boolean d, String s1, String s2) {
                this.camID = a;
                this.devID = b;
                this.sensorID = c;
                this.inUse = d;
                this.SerNo = s1;
                this.Model = s2;
                this.next = null;
            }
        }
    }
}

