/*
 * Decompiled with CFR 0.152.
 */
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumMap;

public class Barcode_Codec
implements PlugIn {
    static final boolean debug = false;
    String sVer = "1D/2D barcode Codec ver. 0.4";
    String sCop = "Copyright \u00a9 2017 F.GANNIER - C.PASQUALIN";

    String getEncoder(String test) {
        String dfltChoice = "";
        int nChoice = 11;
        String[] choice0 = new String[nChoice];
        int n = 0;
        choice0[n++] = "AZTEC";
        choice0[n++] = "CODABAR";
        choice0[n++] = "CODE_39";
        choice0[n++] = "CODE_128";
        choice0[n++] = "DATA_MATRIX";
        choice0[n++] = "EAN_8";
        choice0[n++] = "EAN_13";
        choice0[n++] = "ITF";
        choice0[n++] = "PDF_417";
        choice0[n++] = "QR_CODE";
        choice0[n++] = "UPC_A";
        if (test != null) {
            for (int i = 0; i < nChoice; ++i) {
                if (!test.replace(" ", "").equals(choice0[i])) continue;
                return choice0[i];
            }
            IJ.log((String)("Error :" + test + ". is a bad option"));
        }
        dfltChoice = Prefs.get((String)"Barcode.Encoder", (String)"QR_CODE");
        GenericDialog gd = new GenericDialog(this.sVer);
        gd.addChoice("BarCode Format", choice0, dfltChoice);
        gd.addMessage(this.sCop);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        dfltChoice = gd.getNextChoice();
        Prefs.set((String)"Barcode.Encoder", (String)dfltChoice);
        return dfltChoice;
    }

    void encode(String Format, String text2encode) {
        BitMatrix result;
        MultiFormatWriter writer = new MultiFormatWriter();
        int width = 256;
        int height = 256;
        if (Format == "EAN_8" || Format == "EAN_13" || Format == "CODABAR" || Format == "ITF") {
            height = 128;
        }
        EnumMap<EncodeHintType, String> hints = null;
        hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.DATA_MATRIX_SHAPE, (String)SymbolShapeHint.FORCE_SQUARE);
        try {
            result = writer.encode(text2encode, BarcodeFormat.valueOf((String)Format), width, height, hints);
        }
        catch (IllegalArgumentException iae) {
            IJ.log((String)("Error : " + iae.getMessage()));
            return;
        }
        catch (WriterException iae) {
            IJ.log((String)("Error : " + iae.getMessage()));
            return;
        }
        String stCM = "8-bit Black";
        int pixelsize = 0;
        if (width != result.getWidth()) {
            pixelsize = 3;
        }
        width = result.getWidth();
        height = result.getHeight();
        ImagePlus imp = IJ.createImage((String)"Encoded Image", (String)stCM, (int)width, (int)height, (int)1);
        ImageProcessor ip = imp.getProcessor();
        byte[] pix8 = (byte[])ip.getPixels();
        for (int y = 0; y < result.getHeight(); ++y) {
            int offset = y * result.getWidth();
            for (int x = 0; x < result.getWidth(); ++x) {
                pix8[offset + x] = (byte)(result.get(x, y) ? 0 : 255);
            }
        }
        if (pixelsize > 0) {
            int wOld = width * pixelsize;
            int hOld = height * pixelsize;
            ip = ip.resize(wOld, hOld, false);
            int wNew = width * pixelsize + 16;
            int hNew = height * pixelsize + 16;
            int xOff = (wNew - wOld) / 2;
            int yOff = (hNew - hOld) / 2;
            ImageProcessor ipNew = ip.createProcessor(wNew, hNew);
            ipNew.setColor(new Color(255, 255, 255));
            ipNew.fill();
            ipNew.insert(ip, xOff, yOff);
            new ImagePlus("Encoded Image", ipNew).show();
        } else {
            imp.show();
        }
    }

    void decode(ImageProcessor ip) {
        MultiFormatReader reader = new MultiFormatReader();
        Rectangle r = ip.getRoi();
        BufferedImage myimg = ip.crop().getBufferedImage();
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(myimg);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        String resultText = null;
        BarcodeFormat bf = null;
        EnumMap<DecodeHintType, Boolean> hints = null;
        hints = new EnumMap<DecodeHintType, Boolean>(DecodeHintType.class);
        hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        try {
            Result result = reader.decode(bitmap, hints);
            resultText = result.getText();
            bf = result.getBarcodeFormat();
        }
        catch (NotFoundException e) {
            IJ.log((String)("Error : No corresponding encoder found (" + e.getMessage() + ")"));
        }
        catch (ChecksumException e) {
            IJ.log((String)("Error : checksum error (" + e.getMessage() + ")"));
        }
        catch (FormatException e) {
            IJ.log((String)("Error : Format error (" + e.getMessage() + ")"));
        }
        if (resultText != null) {
            IJ.log((String)(bf.toString() + " detected"));
            new TextWindow("Decoded Text", resultText, 300, 450);
        }
    }

    public void run(String arg) {
        String path = IJ.getDirectory((String)"macros") + "toolsets/";
        String name = "Barcode.ijm";
        File f = new File(path + name);
        if (!f.exists()) {
            InputStream link = this.getClass().getResourceAsStream(name);
            try {
                byte[] buffer = new byte[link.available()];
                link.read(buffer);
                FileOutputStream outStream = new FileOutputStream(f);
                ((OutputStream)outStream).write(buffer);
            }
            catch (IOException e) {
                IJ.log((String)"error");
            }
            IJ.run((String)"Install...", (String)("install=[" + path + name + "]"));
        }
        String options = Macro.getOptions();
        TextWindow win = null;
        Editor winE = null;
        String text2encode = "";
        try {
            win = (TextWindow)WindowManager.getActiveWindow();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (win == null) {
            try {
                winE = (Editor)WindowManager.getActiveWindow();
            }
            catch (ClassCastException classCastException) {}
        } else {
            text2encode = win.getTextPanel().getText();
        }
        if (winE != null) {
            text2encode = winE.getText();
        }
        if (winE != null || win != null) {
            if (text2encode == "") {
                return;
            }
            String Encoder = this.getEncoder(options);
            if (Encoder == null) {
                return;
            }
            this.encode(Encoder, text2encode);
        } else {
            ImagePlus img = WindowManager.getCurrentImage();
            if (img == null) {
                IJ.noImage();
                return;
            }
            this.decode(img.getProcessor());
        }
    }
}

